/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.util.ResultSet;

import java.lang.ref.WeakReference;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jzkit.search.util.RecordModel.ExplicitRecordFormatSpecification;
import org.jzkit.search.util.RecordModel.IndirectFormatProperty;
import org.jzkit.search.util.RecordModel.InformationFragment;
import org.jzkit.search.util.RecordModel.RecordFormatSpecification;
import org.jzkit.search.util.ResultSet.AsynchronousEnumeration;
import org.jzkit.search.util.ResultSet.IFSNotificationTarget;
import org.jzkit.search.util.ResultSet.IRResultSet;
import org.jzkit.search.util.ResultSet.IRResultSetException;

public class ReadAheadEnumeration
implements AsynchronousEnumeration {
    private IRResultSet source = null;
    private int current_element = 0;
    private int min_cache_size = 5;
    private LinkedList fragment_cache = new LinkedList();
    private boolean fetching = false;
    private int chunk_size = -1;
    private RecordFormatSpecification spec = null;
    private int next_to_request = 1;
    private int next_record_timeout = 50000;
    private WeakReference notification_target = null;
    private static Log log = LogFactory.getLog(ReadAheadEnumeration.class);
    IFSNotificationTarget rae_present_callback_handler = new IFSNotificationTarget(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyRecords(InformationFragment[] records) {
            if (records != null) {
                Object o;
                log.debug((Object)("ReadAheadEnumeration::IFSNotificationTarget::records:" + records.length));
                ReadAheadEnumeration.this.next_to_request += records.length;
                LinkedList linkedList = ReadAheadEnumeration.this.fragment_cache;
                synchronized (linkedList) {
                    for (int i = 0; i < records.length; ++i) {
                        if (records[i] != null) {
                            ReadAheadEnumeration.this.fragment_cache.addLast(records[i]);
                            continue;
                        }
                        log.warn((Object)("**source " + ReadAheadEnumeration.this.source.hashCode() + " returned a null information fragment**"));
                    }
                    ReadAheadEnumeration.this.fetching = false;
                    ReadAheadEnumeration.this.fragment_cache.notifyAll();
                }
                ReadAheadEnumeration.this.checkCache();
                if (ReadAheadEnumeration.this.notification_target != null && (o = ReadAheadEnumeration.this.notification_target.get()) != null) {
                    Object t = o;
                    synchronized (t) {
                        o.notifyAll();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyError(String code_set, Integer code, String reason, Throwable source_exception) {
            log.warn((Object)("Error notification " + code_set + " " + code + " " + reason), source_exception);
            if (ReadAheadEnumeration.this.source.getStatus() != 8) {
                ReadAheadEnumeration.this.fetching = false;
                ReadAheadEnumeration.this.checkCache();
                log.warn((Object)"source returned a null information fragment");
            } else {
                LinkedList linkedList = ReadAheadEnumeration.this.fragment_cache;
                synchronized (linkedList) {
                    ReadAheadEnumeration.this.fragment_cache.notifyAll();
                }
            }
        }
    };

    private ReadAheadEnumeration() {
    }

    public ReadAheadEnumeration(IRResultSet source) {
        this(source, new ExplicitRecordFormatSpecification(new IndirectFormatProperty("defaultRecordSyntax"), new IndirectFormatProperty("defaultRecordSchema"), new IndirectFormatProperty("defaultElementSetName")), 10, 100000, null);
    }

    public ReadAheadEnumeration(IRResultSet source, int chunk_size) {
        this(source, new ExplicitRecordFormatSpecification(new IndirectFormatProperty("defaultRecordSyntax"), new IndirectFormatProperty("defaultRecordSchema"), new IndirectFormatProperty("defaultElementSetName")), chunk_size, 100000, null);
    }

    public ReadAheadEnumeration(IRResultSet source, RecordFormatSpecification spec, Object notification_target) {
        this(source, spec, 10, 100000, notification_target);
    }

    public ReadAheadEnumeration(IRResultSet source, RecordFormatSpecification spec) {
        this(source, spec, 10, 100000, null);
    }

    public ReadAheadEnumeration(IRResultSet source, RecordFormatSpecification spec, int chunk_size, int next_record_timeout, Object notification_target) {
        this.chunk_size = chunk_size;
        this.source = source;
        this.spec = spec;
        this.next_record_timeout = next_record_timeout;
        if (notification_target != null) {
            this.notification_target = new WeakReference<Object>(notification_target);
        }
        log.debug((Object)("ReadAheadEumeration::ReadAheadEumeration(source," + chunk_size + "," + spec + ")"));
    }

    public boolean hasMoreElements() {
        return this.current_element < this.source.getFragmentCount();
    }

    public Object nextElement() {
        Object retval = null;
        this.checkCache();
        if (this.fragment_cache.size() == 0) {
            this.waitForNextRecord(this.next_record_timeout);
        }
        if (this.fragment_cache.size() > 0) {
            retval = this.fragment_cache.removeFirst();
        }
        if (retval != null) {
            ++this.current_element;
        }
        return retval;
    }

    private void checkCache() {
        if (this.fragment_cache.size() < this.min_cache_size && this.source.getStatus() != 8 && !this.fetching && this.current_element + this.fragment_cache.size() < this.source.getFragmentCount()) {
            try {
                this.requestRecords();
            }
            catch (IRResultSetException irrse) {
                log.warn((Object)"Problem with result set", (Throwable)irrse);
            }
        }
    }

    private synchronized void requestRecords() throws IRResultSetException {
        if (this.source.getStatus() != 8) {
            this.fetching = true;
            int records_available = this.source.getFragmentCount();
            int num_to_request = 0;
            num_to_request = this.next_to_request + this.chunk_size > records_available ? records_available - this.next_to_request + 1 : this.chunk_size;
            log.debug((Object)"ReadAheadEumeration::fetchRecords()");
            log.debug((Object)("Requesting " + num_to_request + " records, current=" + this.current_element + " max=" + records_available + " next to request=" + this.next_to_request));
            this.source.asyncGetFragment(this.next_to_request, num_to_request, this.spec, this.rae_present_callback_handler);
        }
    }

    public boolean nextIsAvailable() {
        this.checkCache();
        return this.fragment_cache.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForNextRecord(int timeout) {
        switch (timeout) {
            case -1: {
                while (this.fragment_cache.size() == 0) {
                    LinkedList linkedList = this.fragment_cache;
                    synchronized (linkedList) {
                        try {
                            this.fragment_cache.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                break;
            }
            case 0: {
                break;
            }
            default: {
                long end_time = System.currentTimeMillis() + (long)timeout;
                while (System.currentTimeMillis() < end_time && this.fragment_cache.size() == 0 && this.source.getStatus() != 8) {
                    long wait_time = end_time - System.currentTimeMillis();
                    if (wait_time <= 0L) continue;
                    LinkedList linkedList = this.fragment_cache;
                    synchronized (linkedList) {
                        try {
                            this.fragment_cache.wait(wait_time);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                    }
                }
                break block6;
            }
        }
    }

    public void registerNotificationTarget(Object o) {
        this.notification_target = new WeakReference<Object>(o);
    }

    protected void finalize() {
    }
}

