/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.util.RecordBuilder;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jzkit.search.util.RecordBuilder.RecordBuilder;
import org.jzkit.search.util.RecordBuilder.RecordBuilderException;
import org.jzkit.search.util.RecordModel.ExplicitRecordFormatSpecification;
import org.jzkit.search.util.RecordModel.InformationFragment;
import org.jzkit.search.util.RecordModel.InformationFragmentImpl;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.w3c.dom.Document;

public class RecordBuilderService
implements ApplicationContextAware,
ApplicationListener {
    private static Log log = LogFactory.getLog(RecordBuilderService.class);
    private ApplicationContext ctx = null;

    public RecordBuilderService() {
        log.debug((Object)"new RecordBuilderService");
    }

    public void init() {
        log.debug((Object)"RecordBuilderService::init");
    }

    public InformationFragment createFrom(long hitno, String source_repository, String source_collection_name, Object handle, Document source, ExplicitRecordFormatSpecification spec) throws RecordBuilderException {
        InformationFragmentImpl result = null;
        log.debug((Object)("createFragment of " + spec));
        String factory_bean_name = "org.jzkit.recordbuilder." + spec.getEncoding();
        if (this.ctx.containsBean(factory_bean_name)) {
            RecordBuilder rb = (RecordBuilder)this.ctx.getBean(factory_bean_name);
            String element_set_name = null;
            if (spec.getSetname() != null) {
                element_set_name = spec.getSetname().toString();
            }
            Object native_object = rb.createFrom(source, element_set_name);
            result = new InformationFragmentImpl(hitno, source_repository, source_collection_name, handle, native_object, spec);
        } else {
            log.warn((Object)("Cannot locate record builder " + factory_bean_name));
            result = new InformationFragmentImpl(hitno, source_repository, source_collection_name, handle, "Unable to locate record factory " + factory_bean_name, new ExplicitRecordFormatSpecification("string:diag:F"));
        }
        return result;
    }

    public Document getCanonicalXML(InformationFragment f) throws RecordBuilderException {
        Document result = null;
        log.debug((Object)("getCanonicalXML type=" + f.getFormatSpecification()));
        String factory_name = "org.jzkit.recordbuilder." + f.getFormatSpecification().getEncoding();
        if (this.ctx.containsBean(factory_name)) {
            RecordBuilder rb = (RecordBuilder)this.ctx.getBean(factory_name);
            result = rb.getCanonicalXML(f.getOriginalObject());
        } else {
            log.debug((Object)("No RecordBuilder for " + factory_name));
        }
        return result;
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    public void onApplicationEvent(ApplicationEvent evt) {
        log.debug((Object)("onApplicationEvent " + evt));
    }
}

