/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.IOException;
import javax.jms.JMSException;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.transport.stomp.ProtocolConverter;
import org.apache.activemq.transport.stomp.ProtocolException;
import org.apache.activemq.transport.stomp.StompFrame;
import org.apache.activemq.transport.stomp.StompSubscription;

public class StompQueueBrowserSubscription
extends StompSubscription {
    public StompQueueBrowserSubscription(ProtocolConverter stompTransport, String subscriptionId, ConsumerInfo consumerInfo, String transformation) {
        super(stompTransport, subscriptionId, consumerInfo, transformation);
    }

    @Override
    void onMessageDispatch(MessageDispatch md) throws IOException, JMSException {
        if (md.getMessage() != null) {
            super.onMessageDispatch(md);
        } else {
            StompFrame browseDone = new StompFrame("MESSAGE");
            browseDone.getHeaders().put("subscription", this.getSubscriptionId());
            browseDone.getHeaders().put("browser", "end");
            browseDone.getHeaders().put("destination", this.protocolConverter.findTranslator(null).convertDestination(this.protocolConverter, this.destination));
            browseDone.getHeaders().put("message-id", "0");
            this.protocolConverter.sendToStomp(browseDone);
        }
    }

    @Override
    public MessageAck onStompMessageNack(String messageId, TransactionId transactionId) throws ProtocolException {
        throw new ProtocolException("Cannot Nack a message on a Queue Browser Subscription.");
    }
}

