/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.js;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.processor.css.RhinoLessCssProcessor;
import ro.isdc.wro.extensions.processor.support.ObjectPoolHelper;
import ro.isdc.wro.extensions.processor.support.typescript.TypeScriptCompiler;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.Destroyable;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.util.ObjectFactory;

@SupportedResourceType(value=ResourceType.JS)
public class RhinoTypeScriptProcessor
implements ResourcePreProcessor,
ResourcePostProcessor,
Destroyable {
    private static final Logger LOG = LoggerFactory.getLogger(RhinoLessCssProcessor.class);
    public static final String ALIAS = "rhinoTypeScript";
    private ObjectPoolHelper<TypeScriptCompiler> enginePool = new ObjectPoolHelper<TypeScriptCompiler>(new ObjectFactory<TypeScriptCompiler>(){

        public TypeScriptCompiler create() {
            return RhinoTypeScriptProcessor.this.newCompiler();
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        LOG.debug("processing resource: {}", (Object)resource);
        String content = IOUtils.toString((Reader)reader);
        TypeScriptCompiler compiler = this.enginePool.getObject();
        try {
            writer.write(compiler.compile(content));
        }
        catch (Exception e) {
            this.onException(e, content);
        }
        finally {
            this.enginePool.returnObject(compiler);
            reader.close();
            writer.close();
        }
    }

    protected void onException(Exception e, String content) {
        throw WroRuntimeException.wrap((Exception)e);
    }

    protected TypeScriptCompiler newCompiler() {
        return new TypeScriptCompiler();
    }

    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }

    public void destroy() throws Exception {
        this.enginePool.destroy();
    }
}

