/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.a2j.codec.runtime;

import java.io.Serializable;

public class AsnBitString
implements Serializable {
    public int numbytes = 0;
    public int unused_bits = 0;
    public byte[] value = null;

    public AsnBitString() {
        this.numbytes = 1;
        this.value = new byte[1];
    }

    public AsnBitString(byte[] bits, int unused) {
        this.value = bits;
        this.unused_bits = unused;
        this.numbytes = bits.length;
    }

    public AsnBitString(int top_bit_pos) {
        this.numbytes = 1 + top_bit_pos / 8;
        this.value = new byte[this.numbytes];
    }

    byte[] getValue() {
        return this.value;
    }

    private void ensureSize(int bitpos) {
        int num_bytes_needed = 1 + bitpos / 8;
        if (num_bytes_needed > this.numbytes) {
            byte[] newvalue = new byte[num_bytes_needed];
            if (null != this.value) {
                System.arraycopy(this.value, 0, newvalue, 0, this.numbytes);
            }
            this.numbytes = num_bytes_needed;
            this.value = newvalue;
        }
    }

    public void setBit(int bitpos) {
        this.setBit(bitpos, true);
    }

    public void clearBit(int bitpos) {
        this.setBit(bitpos, false);
    }

    public void setBit(int bitpos, boolean set) {
        this.ensureSize(bitpos);
        int octet_to_set = bitpos / 8;
        int bit_to_set = 7 - bitpos % 8;
        if (set) {
            int n = octet_to_set;
            this.value[n] = (byte)(this.value[n] | 1 << bit_to_set);
        } else {
            int n = octet_to_set;
            this.value[n] = (byte)(this.value[n] & ~(1 << bit_to_set));
        }
    }

    public boolean isSet(int bitpos) {
        int bit_to_check;
        byte mask;
        int which_octet = bitpos / 8;
        return which_octet < this.value.length && (this.value[which_octet] & (mask = (byte)(1 << (bit_to_check = 7 - bitpos % 8)))) == mask;
    }
}

