/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.server.http;

import java.util.HashMap;
import java.util.Map;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.rio.ntriples.NTriplesUtil;
import org.openrdf.sesame.sail.RdfSource;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.util.StringUtil;
import org.openrdf.util.http.HttpClientUtil;

public class RdfExplorerUtil {
    private static Map _rdfLabelMap = new HashMap(64);

    public static String getDisplayString(Value value) {
        if (value instanceof URI) {
            return ((URI)value).getURI();
        }
        if (value instanceof BNode) {
            return "_:" + ((BNode)value).getID();
        }
        if (value instanceof Literal) {
            Literal lit = (Literal)value;
            StringBuffer buf = new StringBuffer(32);
            buf.append("\"");
            buf.append(lit.getLabel());
            buf.append("\"");
            if (lit.getLanguage() != null) {
                buf.append("@").append(lit.getLanguage());
            } else if (lit.getDatatype() != null) {
                buf.append("^^").append(lit.getDatatype().getURI());
            }
            return buf.toString();
        }
        return "";
    }

    public static String getLabelForResource(Resource resource, RdfSource rdfSource) {
        String label = (String)_rdfLabelMap.get(resource);
        if (label == null) {
            StatementIterator labelIter = rdfSource.getStatements(resource, URIImpl.RDFS_LABEL, null);
            while (labelIter.hasNext()) {
                Value labelObj = labelIter.next().getObject();
                if (!(labelObj instanceof Literal)) continue;
                label = ((Literal)labelObj).getLabel();
                break;
            }
            labelIter.close();
        }
        return label;
    }

    public static String getQueryString(String repository, Value value, boolean useLabels) {
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("repository", repository);
        params.put("value", NTriplesUtil.toNTriplesString((Value)value));
        if (useLabels) {
            params.put("useLabels", "yes");
        }
        return HttpClientUtil.buildQueryString(params);
    }

    public static String javaScriptEscape(String text) {
        String result = StringUtil.gsub((String)"\\", (String)"\\\\", (String)text);
        result = StringUtil.gsub((String)"\"", (String)"\\\"", (String)result);
        result = StringUtil.gsub((String)"'", (String)"\\'", (String)result);
        return result;
    }

    static {
        _rdfLabelMap.put(URIImpl.RDF_TYPE, "type");
        _rdfLabelMap.put(URIImpl.RDF_PROPERTY, "Property");
        _rdfLabelMap.put(URIImpl.RDF_STATEMENT, "Statement");
        _rdfLabelMap.put(URIImpl.RDF_XMLLITERAL, "XMLLiteral");
        _rdfLabelMap.put(URIImpl.RDF_SUBJECT, "subject");
        _rdfLabelMap.put(URIImpl.RDF_PREDICATE, "predicate");
        _rdfLabelMap.put(URIImpl.RDF_SUBJECT, "object");
        _rdfLabelMap.put(URIImpl.RDF_FIRST, "first");
        _rdfLabelMap.put(URIImpl.RDF_REST, "rest");
        _rdfLabelMap.put(URIImpl.RDF_ALT, "Alt");
        _rdfLabelMap.put(URIImpl.RDF_BAG, "Bag");
        _rdfLabelMap.put(URIImpl.RDF_SEQ, "Seq");
        _rdfLabelMap.put(URIImpl.RDF_LIST, "List");
        _rdfLabelMap.put(URIImpl.RDF_NIL, "nil");
        _rdfLabelMap.put(URIImpl.RDFS_CLASS, "Class");
        _rdfLabelMap.put(URIImpl.RDFS_RESOURCE, "Resource");
        _rdfLabelMap.put(URIImpl.RDFS_LITERAL, "Literal");
        _rdfLabelMap.put(URIImpl.RDFS_SUBCLASSOF, "subClassOf");
        _rdfLabelMap.put(URIImpl.RDFS_SUBPROPERTYOF, "subPropertyOf");
        _rdfLabelMap.put(URIImpl.RDFS_DOMAIN, "domain");
        _rdfLabelMap.put(URIImpl.RDFS_RANGE, "range");
        _rdfLabelMap.put(URIImpl.RDFS_COMMENT, "comment");
        _rdfLabelMap.put(URIImpl.RDFS_LABEL, "label");
        _rdfLabelMap.put(URIImpl.RDFS_ISDEFINEDBY, "isDefinedBy");
        _rdfLabelMap.put(URIImpl.RDFS_SEEALSO, "seeAlso");
        _rdfLabelMap.put(URIImpl.RDFS_MEMBER, "member");
        _rdfLabelMap.put(URIImpl.RDFS_DATATYPE, "Datatype");
        _rdfLabelMap.put(URIImpl.RDFS_CONTAINER, "Container");
        _rdfLabelMap.put(URIImpl.RDFS_CONTAINERMEMBERSHIPPROPERTY, "ContainerMemberShipProperty");
    }
}

