/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.serql;

import java.io.IOException;
import java.io.StringReader;
import org.openrdf.sesame.query.GraphQuery;
import org.openrdf.sesame.query.GraphQueryResultListener;
import org.openrdf.sesame.query.MalformedQueryException;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.TableQuery;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.sesame.query.serql.parser.ParseException;
import org.openrdf.sesame.query.serql.parser.SerqlParser;
import org.openrdf.sesame.query.serql.parser.TokenMgrError;
import org.openrdf.sesame.sail.RdfSource;
import org.openrdf.util.StringUtil;

public class SerqlEngine {
    protected RdfSource _rdfSource;

    public SerqlEngine(RdfSource rdfSource) {
        if (rdfSource == null) {
            throw new IllegalArgumentException("rdfSource must not be nul");
        }
        this._rdfSource = rdfSource;
    }

    public void evaluateSelectQuery(TableQuery tableQuery, TableQueryResultListener tableListener) throws IOException, QueryEvaluationException {
        tableQuery.optimize(this._rdfSource);
        tableQuery.evaluate(this._rdfSource, tableListener);
    }

    public void evaluateConstructQuery(GraphQuery graphQuery, GraphQueryResultListener graphListener) throws IOException, QueryEvaluationException {
        graphQuery.optimize(this._rdfSource);
        graphQuery.evaluate(this._rdfSource, graphListener);
    }

    public TableQuery parseTableQuery(String tableQuery) throws MalformedQueryException {
        tableQuery = this._swapUsingNamespace(tableQuery);
        SerqlParser serqlParser = new SerqlParser(new StringReader(tableQuery));
        try {
            return serqlParser.parseTableQuery();
        }
        catch (TokenMgrError e) {
            throw new MalformedQueryException(e);
        }
        catch (ParseException e) {
            throw new MalformedQueryException(e);
        }
    }

    public GraphQuery parseGraphQuery(String graphQuery) throws MalformedQueryException {
        graphQuery = this._swapUsingNamespace(graphQuery);
        SerqlParser serqlParser = new SerqlParser(new StringReader(graphQuery));
        try {
            return serqlParser.parseGraphQuery();
        }
        catch (TokenMgrError e) {
            throw new MalformedQueryException(e);
        }
        catch (ParseException e) {
            throw new MalformedQueryException(e);
        }
    }

    private String _swapUsingNamespace(String query) {
        String result;
        String queryLC = query.toLowerCase();
        int usingIdx = StringUtil.lastIndexOfWord((String)queryLC, (String)"using");
        if (usingIdx != -1) {
            String part1 = query.substring(0, usingIdx);
            String part2 = query.substring(usingIdx);
            result = part2 + "\n" + part1;
        } else {
            result = query;
        }
        return result;
    }
}

