/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rql.model.iterators;

import java.util.NoSuchElementException;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.sail.ResourceIterator;
import org.openrdf.sesame.sail.ValueIterator;

public abstract class NestedValueIterator
implements ValueIterator {
    protected ResourceIterator _outerIter;
    protected ValueIterator _innerIter;

    public NestedValueIterator(ResourceIterator outerIter) {
        this._outerIter = outerIter;
    }

    public boolean hasNext() throws QueryEvaluationException {
        if (this._innerIter == null || !this._innerIter.hasNext()) {
            while (this._outerIter.hasNext()) {
                Resource outerResource = this._outerIter.nextResource();
                this._innerIter = this.getInnerIterator(outerResource);
                if (!this._innerIter.hasNext()) continue;
            }
        }
        return this._innerIter != null && this._innerIter.hasNext();
    }

    public Value next() throws QueryEvaluationException {
        if (this.hasNext()) {
            return this._innerIter.next();
        }
        throw new NoSuchElementException();
    }

    public abstract ValueIterator getInnerIterator(Resource var1);

    public void close() {
        if (this._outerIter != null) {
            this._outerIter.close();
            this._outerIter = null;
        }
        if (this._innerIter != null) {
            this._innerIter.close();
            this._innerIter = null;
        }
    }

    protected void finalize() {
        this.close();
    }
}

