/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection.proj4;

import java.awt.geom.Point2D;
import java.util.Formatter;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.proj4.LambertConformalConicEllipse;
import ucar.unidata.geoloc.projection.proj4.MapMath;

public class PolyconicProjection
extends ProjectionImpl {
    private double ml0;
    private double[] en;
    private static final double TOL = 1.0E-10;
    private static final double CONV = 1.0E-10;
    private static final int N_ITER = 10;
    private static final int I_ITER = 20;
    private static final double ITOL = 1.0E-12;
    private boolean spherical = true;
    private double projectionLatitude;
    private double projectionLongitude;
    private Earth ellipsoid;
    private double es;
    private double falseEasting;
    private double falseNorthing;
    private double totalScale;

    public PolyconicProjection() {
        this(23.56, 76.54);
    }

    public PolyconicProjection(double lat0, double lon0) {
        this(lat0, lon0, new Earth());
    }

    public PolyconicProjection(double lat0, double lon0, Earth ellipsoid) {
        this(lat0, lon0, 0.0, 0.0, ellipsoid);
    }

    public PolyconicProjection(double lat0, double lon0, double falseEasting, double falseNorthing, Earth ellipsoid) {
        super("Polyconic", false);
        this.projectionLatitude = Math.toRadians(lat0);
        this.projectionLongitude = Math.toRadians(lon0);
        this.ellipsoid = ellipsoid;
        this.falseEasting = falseEasting;
        this.falseNorthing = falseNorthing;
        this.es = this.ellipsoid.getEccentricitySquared();
        this.totalScale = this.ellipsoid.getMajor() * 0.001;
        this.initialize();
        this.addParameter("grid_mapping_name", this.name);
        this.addParameter("latitude_of_projection_origin", lat0);
        this.addParameter("longitude_of_central_meridian", lon0);
        if (falseEasting != 0.0 || falseNorthing != 0.0) {
            this.addParameter("false_easting", falseEasting);
            this.addParameter("false_northing", falseNorthing);
            this.addParameter("units", "km");
        }
        this.addParameter("semi_major_axis", ellipsoid.getMajor());
        this.addParameter("inverse_flattening", 1.0 / ellipsoid.getFlattening());
    }

    private Point2D.Double project(double lplam, double lpphi, Point2D.Double out) {
        if (this.spherical) {
            if (Math.abs(lpphi) <= 1.0E-10) {
                out.x = lplam;
                out.y = this.ml0;
            } else {
                double cot = 1.0 / Math.tan(lpphi);
                double E = lplam * Math.sin(lpphi);
                out.x = Math.sin(E) * cot;
                out.y = lpphi - this.projectionLatitude + cot * (1.0 - Math.cos(E));
            }
        } else if (Math.abs(lpphi) <= 1.0E-10) {
            out.x = lplam;
            out.y = -this.ml0;
        } else {
            double d;
            double sp = Math.sin(lpphi);
            double cp = Math.cos(lpphi);
            double ms = Math.abs(d) > 1.0E-10 ? MapMath.msfn(sp, cp, this.es) / sp : 0.0;
            out.x = ms * Math.sin(out.x *= sp);
            out.y = MapMath.mlfn(lpphi, sp, cp, this.en) - this.ml0 + ms * (1.0 - Math.cos(lplam));
        }
        return out;
    }

    private Point2D.Double projectInverse(double xyx, double xyy, Point2D.Double out) {
        if (this.spherical) {
            double d;
            xyy = this.projectionLatitude + xyy;
            if (Math.abs(d) <= 1.0E-10) {
                out.x = xyx;
                out.y = 0.0;
            } else {
                double dphi;
                double lpphi = xyy;
                double B = xyx * xyx + xyy * xyy;
                int i = 10;
                do {
                    double tp = Math.tan(lpphi);
                    dphi = (xyy * (lpphi * tp + 1.0) - lpphi - 0.5 * (lpphi * lpphi + B) * tp) / ((lpphi - xyy) / tp - 1.0);
                    lpphi -= dphi;
                } while (Math.abs(dphi) > 1.0E-10 && --i > 0);
                if (i == 0) {
                    out.x = Double.NaN;
                    out.y = Double.NaN;
                }
                out.x = Math.asin(xyx * Math.tan(lpphi)) / Math.sin(lpphi);
                out.y = lpphi;
            }
        } else if (Math.abs(xyy += this.ml0) <= 1.0E-10) {
            out.x = xyx;
            out.y = 0.0;
        } else {
            double c;
            int i;
            double r = xyy * xyy + xyx * xyx;
            double lpphi = xyy;
            for (i = 20; i > 0; --i) {
                double sp = Math.sin(lpphi);
                double cp = Math.cos(lpphi);
                double s2ph = sp * cp;
                if (Math.abs(cp) < 1.0E-12) {
                    throw new RuntimeException("I");
                }
                double mlp = Math.sqrt(1.0 - this.es * sp * sp);
                c = sp * mlp / cp;
                double ml = MapMath.mlfn(lpphi, sp, cp, this.en);
                double mlb = ml * ml + r;
                mlp = 1.0 / this.es / (mlp * mlp * mlp);
                double dPhi = (ml + ml + c * mlb - 2.0 * xyy * (c * ml + 1.0)) / (this.es * s2ph * (mlb - 2.0 * xyy * ml) / c + 2.0 * (xyy - ml) * (c * mlp - 1.0 / s2ph) - mlp - mlp);
                lpphi += dPhi;
                if (Math.abs(dPhi) <= 1.0E-12) break;
            }
            if (i == 0) {
                out.x = Double.NaN;
                out.y = Double.NaN;
            }
            c = Math.sin(lpphi);
            out.x = Math.asin(xyx * Math.tan(lpphi) * Math.sqrt(1.0 - this.es * c * c)) / Math.sin(lpphi);
            out.y = lpphi;
        }
        return out;
    }

    public boolean hasInverse() {
        return true;
    }

    private void initialize() {
        if (!this.spherical) {
            this.en = MapMath.enfn(this.es);
            if (this.en == null) {
                throw new RuntimeException("E");
            }
            this.ml0 = MapMath.mlfn(this.projectionLatitude, Math.sin(this.projectionLatitude), Math.cos(this.projectionLatitude), this.en);
        } else {
            this.ml0 = -this.projectionLatitude;
        }
    }

    @Override
    public boolean equals(Object proj) {
        if (!(proj instanceof LambertConformalConicEllipse)) {
            return false;
        }
        PolyconicProjection oo = (PolyconicProjection)proj;
        if (this.getDefaultMapArea() == null != (oo.defaultMapArea == null)) {
            return false;
        }
        if (this.getDefaultMapArea() != null && !this.defaultMapArea.equals(oo.defaultMapArea)) {
            return false;
        }
        return this.getOriginLatitude() == oo.getOriginLatitude() && this.getOriginLongitude() == oo.getOriginLongitude() && this.ellipsoid.equals(oo.getEarth());
    }

    public Earth getEarth() {
        return this.ellipsoid;
    }

    public void setOriginLatitude(double lat) {
        this.projectionLatitude = Math.toRadians(lat);
    }

    public double getOriginLatitude() {
        return Math.toDegrees(this.projectionLatitude);
    }

    public void setOriginLongitude(double lon) {
        this.projectionLongitude = Math.toRadians(lon);
    }

    public double getOriginLongitude() {
        return Math.toDegrees(this.projectionLongitude);
    }

    public double getFalseEasting() {
        return this.falseEasting;
    }

    public void setFalseEasting(double falseEasting) {
        this.falseEasting = falseEasting;
    }

    public double getFalseNorthing() {
        return this.falseNorthing;
    }

    public void setFalseNorthing(double falseNorthing) {
        this.falseNorthing = falseNorthing;
    }

    @Override
    public String getProjectionTypeLabel() {
        return "Polyconic Projection";
    }

    @Override
    public String paramsToString() {
        Formatter f = new Formatter();
        f.format("origin lat=%f, origin lon=%f earth=%s", Math.toDegrees(this.projectionLatitude), Math.toDegrees(this.projectionLongitude), this.ellipsoid);
        return f.toString();
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        if (ProjectionPointImpl.isInfinite(pt1) || ProjectionPointImpl.isInfinite(pt2)) {
            return true;
        }
        return pt1.getX() * pt2.getX() < 0.0 && Math.abs(pt1.getX() - pt2.getX()) > 20000.0;
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latlon, ProjectionPointImpl result) {
        double fromLat = Math.toRadians(latlon.getLatitude());
        double theta = Math.toRadians(latlon.getLongitude());
        if (this.projectionLongitude != 0.0 && !Double.isNaN(theta)) {
            theta = MapMath.normalizeLongitude(theta - this.projectionLongitude);
        }
        Point2D.Double out = new Point2D.Double();
        out = this.project(theta, fromLat, out);
        result.setLocation(this.totalScale * out.x + this.falseEasting, this.totalScale * out.y + this.falseNorthing);
        return result;
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        double fromX = (world.getX() - this.falseEasting) / this.totalScale;
        double fromY = (world.getY() - this.falseNorthing) / this.totalScale;
        Point2D.Double dst = this.projectInverse(fromX, fromY, new Point2D.Double());
        if (dst.x < -Math.PI) {
            dst.x = -Math.PI;
        } else if (dst.x > Math.PI) {
            dst.x = Math.PI;
        }
        if (this.projectionLongitude != 0.0 && !Double.isNaN(dst.x)) {
            dst.x = MapMath.normalizeLongitude(dst.x + this.projectionLongitude);
        }
        result.setLatitude(Math.toDegrees(dst.y));
        result.setLongitude(Math.toDegrees(dst.x));
        return result;
    }

    @Override
    public ProjectionImpl constructCopy() {
        PolyconicProjection result = new PolyconicProjection(this.getOriginLatitude(), this.getOriginLongitude(), this.getFalseEasting(), this.getFalseNorthing(), this.getEarth());
        result.setDefaultMapArea(this.defaultMapArea);
        result.setName(this.name);
        return result;
    }
}

