/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.shapefile;

import java.io.IOException;
import java.nio.ByteOrder;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.io.RandomAccessFile;

public class ShapefileIosp
extends AbstractIOServiceProvider {
    private static final int MAGIC = 9994;
    private static final int VERSION = 1000;
    private Type type;
    private ProjectionRect bb;

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        raf.seek(0L);
        raf.order(ByteOrder.BIG_ENDIAN);
        int fileCode = raf.readInt();
        if (fileCode != 9994) {
            return false;
        }
        raf.seek(28L);
        raf.order(ByteOrder.LITTLE_ENDIAN);
        int version = raf.readInt();
        return version == 1000;
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        super.open(raf, ncfile, cancelTask);
    }

    private void readHeader() throws IOException {
        this.raf.seek(32L);
        this.raf.order(ByteOrder.LITTLE_ENDIAN);
        int itype = this.raf.readInt();
        this.type = this.assignType(itype);
        this.bb = this.readBoundingBox();
    }

    private Type assignType(int type) {
        switch (type) {
            case 1: {
                return Type.point;
            }
            case 3: {
                return Type.polyline;
            }
            case 5: {
                return Type.polygon;
            }
            case 8: {
                return Type.multipoint;
            }
        }
        throw new RuntimeException("shapefile type " + type + " not supported");
    }

    private ProjectionRect readBoundingBox() throws IOException {
        double xMin = this.raf.readDouble();
        double yMin = this.raf.readDouble();
        double xMax = this.raf.readDouble();
        double yMax = this.raf.readDouble();
        return new ProjectionRect(xMin, yMin, xMax, yMax);
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        return null;
    }

    @Override
    public String getFileTypeId() {
        return "Shapefile";
    }

    @Override
    public String getFileTypeDescription() {
        return "ESRI shapefile";
    }

    public static void main(String[] args) throws IOException {
        String fname = "C:\\data\\g4g/EcoAtlas_modern_baylands.shp";
        ShapefileIosp iosp = new ShapefileIosp();
        RandomAccessFile raf = new RandomAccessFile(fname, "r");
        System.out.printf("%s%n", iosp.isValidFile(raf));
    }

    static enum Type {
        none,
        point,
        polyline,
        polygon,
        multipoint;

    }
}

