/*
 * Decompiled with CFR 0.152.
 */
package org.globus.util;

public class CircularBuffer {
    protected Object[] buf;
    protected int in = 0;
    protected int out = 0;
    protected int count = 0;
    protected int size;
    protected boolean interruptPut = false;
    protected boolean interruptGet = false;
    protected boolean closePut = false;

    public CircularBuffer(int size) {
        this.size = size;
        this.buf = new Object[size];
    }

    public synchronized boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized boolean put(Object o) throws InterruptedException {
        if (this.interruptPut) {
            return false;
        }
        while (this.count == this.size) {
            this.wait();
            if (!this.interruptPut) continue;
            return false;
        }
        this.buf[this.in] = o;
        ++this.count;
        this.in = (this.in + 1) % this.size;
        this.notify();
        return true;
    }

    public synchronized Object get() throws InterruptedException {
        if (this.interruptGet) {
            return null;
        }
        while (this.count == 0) {
            if (this.closePut) {
                return null;
            }
            this.wait();
            if (!this.interruptGet) continue;
            return null;
        }
        Object o = this.buf[this.out];
        this.buf[this.out] = null;
        --this.count;
        this.out = (this.out + 1) % this.size;
        this.notify();
        return o;
    }

    public synchronized void closePut() {
        this.closePut = true;
        this.notifyAll();
    }

    public synchronized boolean isPutClosed() {
        return this.closePut;
    }

    public synchronized void interruptBoth() {
        this.interruptGet = true;
        this.interruptPut = true;
        this.notifyAll();
    }

    public synchronized void interruptGet() {
        this.interruptGet = true;
        this.notifyAll();
    }

    public synchronized void interruptPut() {
        this.interruptPut = true;
        this.notifyAll();
    }

    public synchronized boolean isGetInterrupted() {
        return this.interruptGet;
    }

    public synchronized boolean isPutInterrupted() {
        return this.interruptPut;
    }
}

