/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.cloudstack.domain.VMGroup;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.options.CreateVMGroupOptions;
import org.jclouds.cloudstack.options.ListVMGroupsOptions;
import org.jclouds.cloudstack.options.UpdateVMGroupOptions;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface VMGroupApi {
    @Named(value="listInstanceGroups")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listInstanceGroups", "true"})
    @SelectJson(value={"instancegroup"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<VMGroup> listInstanceGroups(ListVMGroupsOptions ... var1);

    @Named(value="listInstanceGroups")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listInstanceGroups", "true"})
    @SelectJson(value={"instancegroup"})
    @OnlyElement
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public VMGroup getInstanceGroup(@QueryParam(value="id") String var1);

    @Named(value="createInstanceGroup")
    @GET
    @QueryParams(keys={"command"}, values={"createInstanceGroup"})
    @SelectJson(value={"instancegroup"})
    @Consumes(value={"application/json"})
    public VMGroup createInstanceGroup(@QueryParam(value="name") String var1, CreateVMGroupOptions ... var2);

    @Named(value="updateInstanceGroup")
    @GET
    @QueryParams(keys={"command"}, values={"updateInstanceGroup"})
    @SelectJson(value={"instancegroup"})
    @Consumes(value={"application/json"})
    public VMGroup updateInstanceGroup(@QueryParam(value="id") String var1, UpdateVMGroupOptions ... var2);

    @Named(value="deleteInstanceGroup")
    @GET
    @QueryParams(keys={"command"}, values={"deleteInstanceGroup"})
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void deleteInstanceGroup(@QueryParam(value="id") String var1);
}

