/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.csw.services.getrecords.es;

import java.util.Deque;
import org.fao.geonet.kernel.csw.services.getrecords.IFieldMapper;
import org.geotools.filter.expression.AbstractExpressionVisitor;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTWriter;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class Expression2CswVisitor
extends AbstractExpressionVisitor {
    public static final WKTWriter WKT_WRITER = new WKTWriter();
    private final IFieldMapper fieldMapper;
    private final Deque<String> stack;

    public Expression2CswVisitor(Deque<String> stack, IFieldMapper fieldMapper) {
        this.stack = stack;
        this.fieldMapper = fieldMapper;
    }

    private static String quoteString(String text) {
        return text.replace("\"", "\\\"");
    }

    public Object visit(PropertyName expr, Object extraData) {
        this.stack.push(this.fieldMapper.map(expr.getPropertyName()));
        return expr;
    }

    public Object visit(Literal expr, Object extraData) {
        if (expr.getValue() instanceof Geometry) {
            Geometry geometry = (Geometry)expr.getValue();
            this.geometry2coordinates(geometry);
        } else {
            this.stack.push(Expression2CswVisitor.quoteString(expr.getValue().toString()));
        }
        return expr;
    }

    private void geometry2coordinates(Geometry geometry) {
        try {
            CoordinateReferenceSystem sourceCRS = geometry.getUserData() != null && geometry.getUserData() instanceof CoordinateReferenceSystem ? (CoordinateReferenceSystem)geometry.getUserData() : CRS.decode((String)("EPSG:" + geometry.getSRID()));
            CoordinateReferenceSystem targetCRS = CRS.decode((String)"EPSG:4326");
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
            geometry = JTS.transform((Geometry)geometry, (MathTransform)transform);
        }
        catch (FactoryException | TransformException e) {
            e.printStackTrace();
        }
        this.stack.push(geometry.toText());
    }
}

