/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.csw.common;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fao.geonet.csw.common.Csw;
import org.fao.geonet.csw.common.CswOperation;
import org.fao.geonet.csw.common.TypeName;
import org.fao.geonet.utils.Log;
import org.jdom.Element;
import org.jdom.Namespace;

public class CswServer {
    public static final String GET_RECORDS = "GetRecords";
    public static final String GET_RECORD_BY_ID = "GetRecordById";
    private Map<String, CswOperation> operations = new HashMap<String, CswOperation>();
    private List<String> logs = new ArrayList<String>();
    private String preferredServerVersion = "2.0.2";

    public CswServer(Element capab) {
        this.parse(capab);
    }

    public void parse(Element capab) {
        this.logs.clear();
        this.operations.clear();
        this.parseVersions(capab);
        this.parseOperations(capab);
    }

    public CswOperation getOperation(String name) {
        return this.operations.get(name);
    }

    public String getPreferredServerVersion() {
        return this.preferredServerVersion;
    }

    private void parseOperations(Element capabil) {
        Element operMd = capabil.getChild("OperationsMetadata", Csw.NAMESPACE_OWS);
        if (operMd == null) {
            this.log("Missing 'ows:OperationsMetadata' element");
        } else {
            for (Object e : operMd.getChildren()) {
                CswOperation oper;
                Element elem = (Element)e;
                if (!"Operation".equals(elem.getName()) || (oper = this.extractOperation(elem)) == null) continue;
                this.operations.put(oper.getName(), oper);
            }
        }
    }

    private CswOperation extractOperation(Element oper) {
        String name = oper.getAttributeValue("name");
        if (name == null) {
            this.log("Operation has no 'name' attribute");
            return null;
        }
        CswOperation op = new CswOperation();
        op.setName(name);
        List dcp = oper.getChildren("DCP", Csw.NAMESPACE_OWS);
        this.evaluateUrl(dcp, op);
        List parameters = oper.getChildren("Parameter", Csw.NAMESPACE_OWS);
        this.log("Found " + parameters.size() + " parameters for operation: " + name);
        List outputSchemas = null;
        List typeNames = null;
        List outputFormats = null;
        List constraintLanguages = null;
        for (Element parameter : parameters) {
            List tmp;
            String parameterName = parameter.getAttributeValue("name");
            this.log("Processing parameter: " + parameterName);
            if (parameterName != null && parameterName.equalsIgnoreCase("outputSchema")) {
                outputSchemas = tmp = parameter.getChildren("Value", Csw.NAMESPACE_OWS);
                this.log("Found " + outputSchemas.size() + " outputSchemas for operation: " + name);
            }
            if (parameterName != null && (parameterName.equalsIgnoreCase("typeNames") || parameterName.equalsIgnoreCase("typeName"))) {
                typeNames = tmp = parameter.getChildren("Value", Csw.NAMESPACE_OWS);
                this.log("Found " + typeNames.size() + " typeNames for operation: " + name);
            }
            if (parameterName != null && parameterName.equalsIgnoreCase("outputFormat")) {
                outputFormats = tmp = parameter.getChildren("Value", Csw.NAMESPACE_OWS);
                this.log("Found " + outputFormats.size() + " outputFormats for operation: " + name);
            }
            if (parameterName == null || !parameterName.equalsIgnoreCase("CONSTRAINTLANGUAGE")) continue;
            constraintLanguages = tmp = parameter.getChildren("Value", Csw.NAMESPACE_OWS);
            this.log("Found " + constraintLanguages.size() + " constraintLanguage for operation: " + name);
        }
        if (outputSchemas != null) {
            for (Element outputSchema : outputSchemas) {
                String outputSchemaValue = outputSchema.getValue();
                this.log("Adding outputSchema: " + outputSchemaValue + " to operation: " + name);
                op.getOutputSchemaList().add(outputSchemaValue);
            }
            op.choosePreferredOutputSchema();
        } else {
            this.log("No outputSchema for operation: " + name);
        }
        if (constraintLanguages != null) {
            for (Element constraintLanguage : constraintLanguages) {
                String constraintLanguageValue = constraintLanguage.getValue().toLowerCase();
                this.log("Adding constraintLanguage : " + constraintLanguageValue + " to operation: " + name);
                if ("cql".equals(constraintLanguageValue)) {
                    this.log(" Some implementation use CQL instead of CQL_TEXT for the CQL constraint language value.");
                    constraintLanguageValue = "cql_text";
                }
                op.getConstraintLanguage().add(constraintLanguageValue);
            }
        } else {
            this.log("No constraintLanguage for operation: " + name);
        }
        if (typeNames != null) {
            for (Element typeName : typeNames) {
                String typeNameValue = typeName.getValue();
                this.log("Adding typeName: " + typeNameValue + " to operation: " + name);
                TypeName tn = TypeName.getTypeName(typeNameValue);
                if (tn != null) {
                    op.getTypeNamesList().add(typeNameValue);
                    continue;
                }
                this.log("  Unsupported typeName found: " + typeNameValue + ".");
            }
        } else {
            this.log("No typeNames for operation: " + name);
        }
        if (outputFormats != null) {
            for (Element outputFormat : outputFormats) {
                String outputFormatValue = outputFormat.getValue();
                this.log("Adding outputFormat: " + outputFormatValue + " to operation: " + name);
                op.getOutputFormatList().add(outputFormatValue);
            }
            op.choosePreferredOutputFormat();
        } else {
            op.setPreferredOutputFormat("application/xml");
            this.log("No outputFormat for operation: " + name);
        }
        op.setPreferredServerVersion(this.preferredServerVersion);
        return op;
    }

    private void parseVersions(Element capabil) {
        ArrayList<String> serverVersions = new ArrayList<String>();
        Element serviceIdentificationMd = capabil.getChild("ServiceIdentification", Csw.NAMESPACE_OWS);
        if (serviceIdentificationMd == null) {
            this.log("Missing 'ows:ServiceTypeVersion' element");
        } else {
            List serviceIdentificationMdElems = serviceIdentificationMd.getChildren();
            for (Element value : serviceIdentificationMdElems) {
                String valueName = value.getName();
                this.log("Processing value: " + valueName);
                if (valueName == null || !valueName.equalsIgnoreCase("ServiceTypeVersion")) continue;
                serverVersions.add(value.getValue());
            }
        }
        if (serverVersions.isEmpty()) {
            serverVersions.add("2.0.2");
        }
        ArrayList<String> preferenceVersions = new ArrayList<String>();
        preferenceVersions.add("2.0.2");
        preferenceVersions.add("2.0.1");
        preferenceVersions.add("2.0.0");
        for (String nextBest : preferenceVersions) {
            if (!serverVersions.contains(nextBest)) continue;
            this.preferredServerVersion = nextBest;
            break;
        }
    }

    private void evaluateUrl(List<Element> dcps, CswOperation op) {
        if (dcps == null) {
            this.log("Missing 'ows:DCP' element in operation");
            return;
        }
        Namespace ns = Namespace.getNamespace((String)"http://www.w3.org/1999/xlink");
        block4: for (Element dcp : dcps) {
            Element http = dcp.getChild("HTTP", Csw.NAMESPACE_OWS);
            if (http == null) {
                this.log("Missing 'ows:HTTP' element in operation/DCP");
                continue;
            }
            Element getUrl = http.getChild("Get", Csw.NAMESPACE_OWS);
            if (getUrl == null) {
                this.log("No GET url found in current DCP. Checking POST ...");
            } else {
                String tmpGetUrl = getUrl.getAttributeValue("href", ns);
                if (tmpGetUrl != null && op.getGetUrl() == null) {
                    try {
                        op.setGetUrl(new URL(tmpGetUrl));
                        this.log("Found URL (GET method): " + tmpGetUrl);
                    }
                    catch (MalformedURLException e) {
                        this.log("Malformed 'xlink:href' attribute in operation's http method");
                    }
                }
            }
            List postUrlList = http.getChildren("Post", Csw.NAMESPACE_OWS);
            for (Element postUrl : postUrlList) {
                Element value;
                if (postUrl == null) {
                    this.log("No POST url found in current DCP.");
                    continue;
                }
                String tmpPostUrl = postUrl.getAttributeValue("href", ns);
                if (tmpPostUrl == null) {
                    this.log("Missing 'xlink:href' attribute in operation's http method");
                    continue;
                }
                if (op.getPostUrl() != null) continue;
                Element methodConstraint = postUrl.getChild("Constraint", Csw.NAMESPACE_OWS);
                if (methodConstraint != null && (value = methodConstraint.getChild("Value", Csw.NAMESPACE_OWS)) != null && value.getText().equals("SOAP")) {
                    this.log("The URL " + tmpPostUrl + " using POST/SOAP method is not supported for harvesting.");
                    continue;
                }
                try {
                    op.setPostUrl(new URL(tmpPostUrl));
                    this.log("Found URL (POST method):" + tmpPostUrl);
                    continue block4;
                }
                catch (MalformedURLException e) {
                    this.log("Malformed 'xlink:href' attribute in operation's http method");
                }
            }
        }
    }

    private void log(String message) {
        this.logs.add(message);
        if (Log.isDebugEnabled((String)"geonetwork.harvest-man")) {
            Log.debug((String)"geonetwork.harvest-man", (Object)message);
        }
    }
}

