/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.util;

import java.awt.RenderingHints;
import java.text.FieldPosition;
import java.util.Locale;
import org.geotools.measure.AngleFormat;
import org.geotools.measure.Latitude;
import org.geotools.measure.Longitude;
import org.geotools.metadata.i18n.Errors;
import org.geotools.metadata.iso.extent.GeographicBoundingBoxImpl;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.TransformPathNotFoundException;
import org.geotools.referencing.util.CRSUtilities;
import org.geotools.util.factory.Hints;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.TransformException;

public final class BoundingBoxes {
    private static final Hints LENIENT = new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);

    private BoundingBoxes() {
    }

    public static void copy(Envelope envelope, GeographicBoundingBoxImpl box) throws TransformException {
        GeographicCRS standardCRS;
        CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
        if (!(crs == null || BoundingBoxes.startsWith(crs, (CoordinateReferenceSystem)(standardCRS = CRSUtilities.getStandardGeographicCRS2D(crs))) || BoundingBoxes.startsWith(crs, DefaultGeographicCRS.WGS84) || BoundingBoxes.startsWith(crs, DefaultGeographicCRS.WGS84_3D))) {
            CoordinateOperation operation;
            CoordinateOperationFactory factory = ReferencingFactoryFinder.getCoordinateOperationFactory(LENIENT);
            try {
                operation = factory.createOperation(crs, (CoordinateReferenceSystem)standardCRS);
            }
            catch (FactoryException exception) {
                throw new TransformPathNotFoundException(Errors.format((int)33, (Object)((Object)exception)));
            }
            envelope = CRS.transform(operation, envelope);
        }
        box.setWestBoundLongitude(envelope.getMinimum(0));
        box.setEastBoundLongitude(envelope.getMaximum(0));
        box.setSouthBoundLatitude(envelope.getMinimum(1));
        box.setNorthBoundLatitude(envelope.getMaximum(1));
    }

    private static final boolean startsWith(CoordinateReferenceSystem crs, CoordinateReferenceSystem head) {
        int dimension = head.getCoordinateSystem().getDimension();
        return crs.getCoordinateSystem().getDimension() >= dimension && CRS.equalsIgnoreMetadata(CRSUtilities.getSubCRS(crs, 0, dimension), head);
    }

    public static String toString(GeographicBoundingBox box, String pattern, Locale locale) {
        AngleFormat format = locale != null ? new AngleFormat(pattern, locale) : new AngleFormat(pattern);
        FieldPosition pos = new FieldPosition(0);
        StringBuffer buffer = new StringBuffer();
        format.format(new Latitude(box.getNorthBoundLatitude()), buffer, pos).append(", ");
        format.format(new Longitude(box.getWestBoundLongitude()), buffer, pos).append(" - ");
        format.format(new Latitude(box.getSouthBoundLatitude()), buffer, pos).append(", ");
        format.format(new Longitude(box.getEastBoundLongitude()), buffer, pos);
        return buffer.toString();
    }
}

