/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.impl;

import java.io.IOException;
import java.rmi.dgc.VMID;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jzkit.search.DeduplicationModel;
import org.jzkit.search.LandscapeSpecification;
import org.jzkit.search.SearchSession;
import org.jzkit.search.SortModel;
import org.jzkit.search.StatelessSearchResultsPageDTO;
import org.jzkit.search.provider.iface.Condition;
import org.jzkit.search.provider.iface.OrCondition;
import org.jzkit.search.provider.iface.SearchException;
import org.jzkit.search.util.QueryModel.Internal.HumanReadableQueryBundle;
import org.jzkit.search.util.QueryModel.Internal.HumanReadableVisitor;
import org.jzkit.search.util.QueryModel.Internal.InternalModelRootNode;
import org.jzkit.search.util.QueryModel.InvalidQueryException;
import org.jzkit.search.util.QueryModel.QueryModel;
import org.jzkit.search.util.RecordModel.ExplicitRecordFormatSpecification;
import org.jzkit.search.util.RecordModel.InformationFragment;
import org.jzkit.search.util.RecordModel.RecordFormatSpecification;
import org.jzkit.search.util.ResultSet.IRResultSetException;
import org.jzkit.search.util.ResultSet.RSStatusMaskCondition;
import org.jzkit.search.util.ResultSet.ResultCountCondition;
import org.jzkit.search.util.ResultSet.TransformingIRResultSet;
import org.springframework.context.ApplicationContext;

public class CachedSearchSession {
    private SearchSession search_session = null;
    private String result_set_id = null;
    private TransformingIRResultSet transforming_ir_result_set = null;
    private static Log log = LogFactory.getLog(CachedSearchSession.class);
    private long last_used = System.currentTimeMillis();
    private String query_type = null;
    private String query_string = null;
    private HumanReadableQueryBundle human_readable_bundle = null;
    private ApplicationContext ctx = null;
    protected boolean active = true;
    protected static int inst_count = 0;

    private CachedSearchSession() {
        log.info((Object)("new CachedSearchSession(" + ++inst_count + ")"));
    }

    public CachedSearchSession(SearchSession search_session, ApplicationContext ctx) {
        log.info((Object)("new CachedSearchSession(" + ++inst_count + ")"));
        this.search_session = search_session;
        this.result_set_id = new VMID().toString();
        this.ctx = ctx;
    }

    public void search(LandscapeSpecification landscape, QueryModel model, RecordFormatSpecification rfs) throws SearchException {
        this.search(landscape, model, null, null, rfs);
    }

    public void search(LandscapeSpecification landscape, QueryModel model, DeduplicationModel deduplication_model, SortModel sort_model, RecordFormatSpecification rfs) throws SearchException {
        this.transforming_ir_result_set = this.search_session.search(landscape, model, deduplication_model, sort_model, rfs);
        try {
            this.human_readable_bundle = new HumanReadableQueryBundle();
            HumanReadableVisitor.toHumanReadableBundle((InternalModelRootNode)model.toInternalQueryModel(this.ctx), (HumanReadableQueryBundle)this.human_readable_bundle);
        }
        catch (IOException ioe) {
            log.warn((Object)"Problem", (Throwable)ioe);
        }
        catch (InvalidQueryException iqe) {
            log.warn((Object)"Problem", (Throwable)iqe);
        }
    }

    public String getResultSetId() {
        return this.result_set_id;
    }

    public StatelessSearchResultsPageDTO getResultsPageFor(int first_hit, int num_hits, RecordFormatSpecification rfs, ExplicitRecordFormatSpecification display_spec, Map additional_properties) throws SearchException, IRResultSetException {
        log.debug((Object)("getResultsPageFor " + first_hit + ", " + num_hits + ", rfs:" + rfs + ", ds:" + display_spec));
        StatelessSearchResultsPageDTO result = null;
        this.touch();
        Object c = null;
        c = first_hit == 0 && num_hits == 0 ? new RSStatusMaskCondition(12) : new OrCondition(new Condition[]{new ResultCountCondition(first_hit + num_hits - 1), new RSStatusMaskCondition(12)});
        if (this.transforming_ir_result_set.waitForCondition((Condition)c, 120000L)) {
            int num_to_request = 0;
            log.debug((Object)("first hit " + first_hit + " num to request " + num_hits + " count " + this.transforming_ir_result_set.getFragmentCount()));
            if (first_hit > this.transforming_ir_result_set.getFragmentCount()) {
                log.debug((Object)"Present out of range");
            } else {
                num_to_request = first_hit + num_hits - 1 <= this.transforming_ir_result_set.getFragmentCount() ? num_hits : this.transforming_ir_result_set.getFragmentCount() - first_hit + 1;
            }
            InformationFragment[] fragments = null;
            if (num_to_request > 0) {
                log.debug((Object)("Calling get fragment... requesting " + num_to_request + " from " + first_hit + " spec=" + display_spec));
                fragments = this.transforming_ir_result_set.getFragment(first_hit, num_to_request, rfs, display_spec, additional_properties);
            } else {
                log.debug((Object)"Not requesting any records");
            }
            result = new StatelessSearchResultsPageDTO(this.result_set_id, this.transforming_ir_result_set.getStatus(), num_to_request, first_hit, this.transforming_ir_result_set.getFragmentCount(), null, fragments, this.transforming_ir_result_set.getResultSetInfo());
        } else {
            log.warn((Object)"Search failure in some way - most likely timeout waiting for result records");
            result = new StatelessSearchResultsPageDTO(this.result_set_id, this.transforming_ir_result_set.getStatus(), this.transforming_ir_result_set.getFragmentCount(), first_hit, 0, null, null, this.transforming_ir_result_set.getResultSetInfo());
        }
        result.setHumanReadableQueryBundle(this.human_readable_bundle);
        log.debug((Object)"leaving getResultsPageFor..");
        return result;
    }

    public void close() {
        log.info((Object)"close - Closing RS and Session");
        this.active = false;
        this.transforming_ir_result_set.close();
        this.search_session.close();
    }

    protected void finalize() {
        log.info((Object)("finalize CachedSearchSession(" + --inst_count + ")"));
    }

    public void touch() {
        this.last_used = System.currentTimeMillis();
    }

    public long getLastUsed() {
        return this.last_used;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }
}

