/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.features;

import com.google.common.collect.FluentIterable;
import javax.inject.Named;
import javax.ws.rs.POST;
import org.jclouds.Fallbacks;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.ultradns.ws.UltraDNSWSExceptions;
import org.jclouds.ultradns.ws.binders.ZoneAndResourceRecordToXML;
import org.jclouds.ultradns.ws.domain.ResourceRecord;
import org.jclouds.ultradns.ws.domain.ResourceRecordDetail;
import org.jclouds.ultradns.ws.filters.SOAPWrapWithPasswordAuth;
import org.jclouds.ultradns.ws.xml.ElementTextHandler;
import org.jclouds.ultradns.ws.xml.ResourceRecordListHandler;

@RequestFilters(value={SOAPWrapWithPasswordAuth.class})
@VirtualHost
public interface ResourceRecordApi {
    @Named(value="createResourceRecord")
    @POST
    @XMLResponseParser(value=ElementTextHandler.Guid.class)
    @MapBinder(value=ZoneAndResourceRecordToXML.class)
    public String create(@PayloadParam(value="resourceRecord") ResourceRecord var1) throws UltraDNSWSExceptions.ResourceAlreadyExistsException;

    @Named(value="updateResourceRecord")
    @POST
    @MapBinder(value=ZoneAndResourceRecordToXML.class)
    public void update(@PayloadParam(value="guid") String var1, @PayloadParam(value="resourceRecord") ResourceRecord var2) throws ResourceNotFoundException;

    @Named(value="getResourceRecordsOfZone")
    @POST
    @XMLResponseParser(value=ResourceRecordListHandler.class)
    @Payload(value="<v01:getResourceRecordsOfZone><zoneName>{zoneName}</zoneName><rrType>0</rrType></v01:getResourceRecordsOfZone>")
    public FluentIterable<ResourceRecordDetail> list() throws ResourceNotFoundException;

    @Named(value="getResourceRecordsOfDNameByType")
    @POST
    @XMLResponseParser(value=ResourceRecordListHandler.class)
    @Payload(value="<v01:getResourceRecordsOfDNameByType><zoneName>{zoneName}</zoneName><hostName>{hostName}</hostName><rrType>0</rrType></v01:getResourceRecordsOfDNameByType>")
    public FluentIterable<ResourceRecordDetail> listByName(@PayloadParam(value="hostName") String var1) throws ResourceNotFoundException;

    @Named(value="getResourceRecordsOfDNameByType")
    @POST
    @XMLResponseParser(value=ResourceRecordListHandler.class)
    @Payload(value="<v01:getResourceRecordsOfDNameByType><zoneName>{zoneName}</zoneName><hostName>{hostName}</hostName><rrType>{rrType}</rrType></v01:getResourceRecordsOfDNameByType>")
    public FluentIterable<ResourceRecordDetail> listByNameAndType(@PayloadParam(value="hostName") String var1, @PayloadParam(value="rrType") int var2) throws ResourceNotFoundException;

    @Named(value="deleteResourceRecord")
    @POST
    @Payload(value="<v01:deleteResourceRecord><transactionID /><guid>{guid}</guid></v01:deleteResourceRecord>")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void delete(@PayloadParam(value="guid") String var1);
}

