/*
 * Decompiled with CFR 0.152.
 */
package org.z3950.zing.cql;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Vector;
import org.z3950.zing.cql.CQLAndNode;
import org.z3950.zing.cql.CQLLexer;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLNotNode;
import org.z3950.zing.cql.CQLOrNode;
import org.z3950.zing.cql.CQLParseException;
import org.z3950.zing.cql.CQLPrefixNode;
import org.z3950.zing.cql.CQLProxNode;
import org.z3950.zing.cql.CQLRelation;
import org.z3950.zing.cql.CQLTermNode;
import org.z3950.zing.cql.PQFTranslationException;
import org.z3950.zing.cql.UnknownPositionException;
import org.z3950.zing.cql.UnknownQualifierException;
import org.z3950.zing.cql.UnknownRelationException;
import org.z3950.zing.cql.UnknownRelationModifierException;

public class CQLParser {
    private CQLLexer lexer;
    private static boolean DEBUG = false;
    private static boolean LEXDEBUG = false;

    private static void debug(String string) {
        if (DEBUG) {
            System.err.println("PARSEDEBUG: " + string);
        }
    }

    public CQLNode parse(String string) throws CQLParseException, IOException {
        this.lexer = new CQLLexer(string, LEXDEBUG);
        this.lexer.nextToken();
        CQLParser.debug("about to parseQuery()");
        CQLNode cQLNode = this.parseQuery("cql.serverChoice", new CQLRelation("scr"));
        if (this.lexer.ttype != -1) {
            throw new CQLParseException("junk after end: " + this.lexer.render());
        }
        return cQLNode;
    }

    /*
     * Enabled aggressive block sorting
     */
    private CQLNode parseQuery(String string, CQLRelation cQLRelation) throws CQLParseException, IOException {
        CQLParser.debug("in parseQuery()");
        CQLNode cQLNode = this.parseTerm(string, cQLRelation);
        while (this.lexer.ttype != -1 && this.lexer.ttype != 41) {
            CQLNode cQLNode2;
            if (this.lexer.ttype == CQLLexer.TT_AND) {
                this.match(CQLLexer.TT_AND);
                cQLNode2 = this.parseTerm(string, cQLRelation);
                cQLNode = new CQLAndNode(cQLNode, cQLNode2);
                continue;
            }
            if (this.lexer.ttype == CQLLexer.TT_OR) {
                this.match(CQLLexer.TT_OR);
                cQLNode2 = this.parseTerm(string, cQLRelation);
                cQLNode = new CQLOrNode(cQLNode, cQLNode2);
                continue;
            }
            if (this.lexer.ttype == CQLLexer.TT_NOT) {
                this.match(CQLLexer.TT_NOT);
                cQLNode2 = this.parseTerm(string, cQLRelation);
                cQLNode = new CQLNotNode(cQLNode, cQLNode2);
                continue;
            }
            if (this.lexer.ttype != CQLLexer.TT_PROX) {
                throw new CQLParseException("expected boolean, got " + this.lexer.render());
            }
            this.match(CQLLexer.TT_PROX);
            cQLNode2 = new CQLProxNode(cQLNode);
            this.gatherProxParameters((CQLProxNode)cQLNode2);
            CQLNode cQLNode3 = this.parseTerm(string, cQLRelation);
            ((CQLProxNode)cQLNode2).addSecondSubterm(cQLNode3);
            cQLNode = cQLNode2;
        }
        CQLParser.debug("no more ops");
        return cQLNode;
    }

    private CQLNode parseTerm(String string, CQLRelation cQLRelation) throws CQLParseException, IOException {
        String string2;
        CQLParser.debug("in parseTerm()");
        while (true) {
            if (this.lexer.ttype == 40) {
                CQLParser.debug("parenthesised term");
                this.match(40);
                CQLNode cQLNode = this.parseQuery(string, cQLRelation);
                this.match(41);
                return cQLNode;
            }
            if (this.lexer.ttype == 62) {
                this.match(62);
                return this.parsePrefix(string, cQLRelation);
            }
            CQLParser.debug("non-parenthesised term");
            string2 = this.matchSymbol("qualifier or term");
            if (!this.isBaseRelation()) break;
            string = string2;
            cQLRelation = new CQLRelation(this.lexer.ttype == -3 ? this.lexer.sval : this.lexer.render(this.lexer.ttype, false));
            this.match(this.lexer.ttype);
            while (this.lexer.ttype == 47) {
                this.match(47);
                if (this.lexer.ttype != CQLLexer.TT_RELEVANT) {
                    if (this.lexer.ttype != CQLLexer.TT_FUZZY) {
                        if (this.lexer.ttype != CQLLexer.TT_STEM) {
                            if (this.lexer.ttype != CQLLexer.TT_PHONETIC) {
                                if (this.lexer.ttype != -3) {
                                    throw new CQLParseException("expected relation modifier, got " + this.lexer.render());
                                }
                            }
                        }
                    }
                }
                if (this.lexer.ttype == -3 && this.lexer.sval.indexOf(46) == -1) {
                    throw new CQLParseException("unknown first-class relation modifier: " + this.lexer.sval);
                }
                cQLRelation.addModifier(this.lexer.sval.toLowerCase());
                this.match(this.lexer.ttype);
            }
            CQLParser.debug("qualifier='" + string + ", " + "relation='" + cQLRelation.toCQL() + "'");
        }
        CQLTermNode cQLTermNode = new CQLTermNode(string, cQLRelation, string2);
        CQLParser.debug("made term node " + cQLTermNode.toCQL());
        return cQLTermNode;
    }

    private CQLNode parsePrefix(String string, CQLRelation cQLRelation) throws CQLParseException, IOException {
        CQLParser.debug("prefix mapping");
        String string2 = null;
        String string3 = this.matchSymbol("prefix-name");
        if (this.lexer.ttype == 61) {
            this.match(61);
            string2 = string3;
            string3 = this.matchSymbol("prefix-identifer");
        }
        CQLNode cQLNode = this.parseQuery(string, cQLRelation);
        return new CQLPrefixNode(string2, string3, cQLNode);
    }

    private void gatherProxParameters(CQLProxNode cQLProxNode) throws CQLParseException, IOException {
        cQLProxNode.addModifier("relation", "=");
        cQLProxNode.addModifier("unit", "word");
        cQLProxNode.addModifier("distance", "1");
        cQLProxNode.addModifier("ordering", this.lexer.render(CQLLexer.TT_ORDERED, false));
        block6: for (int i = 0; i < 4; ++i) {
            if (this.lexer.ttype != 47) {
                return;
            }
            this.match(47);
            if (this.lexer.ttype == 47) continue;
            switch (i) {
                case 0: {
                    this.gatherProxRelation(cQLProxNode);
                    continue block6;
                }
                case 1: {
                    this.gatherProxDistance(cQLProxNode);
                    continue block6;
                }
                case 2: {
                    this.gatherProxUnit(cQLProxNode);
                    continue block6;
                }
                case 3: {
                    this.gatherProxOrdering(cQLProxNode);
                }
            }
        }
    }

    private void gatherProxRelation(CQLProxNode cQLProxNode) throws CQLParseException, IOException {
        if (!this.isProxRelation()) {
            throw new CQLParseException("expected proximity relation, got " + this.lexer.render());
        }
        cQLProxNode.addModifier("relation", this.lexer.render(this.lexer.ttype, false));
        this.match(this.lexer.ttype);
        CQLParser.debug("gPR matched " + this.lexer.render(this.lexer.ttype, false));
    }

    private void gatherProxDistance(CQLProxNode cQLProxNode) throws CQLParseException, IOException {
        if (Character.isDigit(this.lexer.sval.charAt(0))) {
            System.out.println("might have a number here!");
        }
        cQLProxNode.addModifier("distance", this.lexer.sval);
        this.match(this.lexer.ttype);
        CQLParser.debug("gPD matched " + this.lexer.render(this.lexer.ttype, false));
    }

    private void gatherProxUnit(CQLProxNode cQLProxNode) throws CQLParseException, IOException {
        if (this.lexer.ttype != CQLLexer.TT_pWORD) {
            if (this.lexer.ttype != CQLLexer.TT_SENTENCE) {
                if (this.lexer.ttype != CQLLexer.TT_PARAGRAPH) {
                    if (this.lexer.ttype != CQLLexer.TT_ELEMENT) {
                        throw new CQLParseException("expected proximity unit, got " + this.lexer.render());
                    }
                }
            }
        }
        cQLProxNode.addModifier("unit", this.lexer.render());
        this.match(this.lexer.ttype);
    }

    private void gatherProxOrdering(CQLProxNode cQLProxNode) throws CQLParseException, IOException {
        if (this.lexer.ttype != CQLLexer.TT_ORDERED) {
            if (this.lexer.ttype != CQLLexer.TT_UNORDERED) {
                throw new CQLParseException("expected proximity ordering, got " + this.lexer.render());
            }
        }
        cQLProxNode.addModifier("ordering", this.lexer.render());
        this.match(this.lexer.ttype);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isBaseRelation() throws CQLParseException {
        CQLParser.debug("isBaseRelation: checking ttype=" + this.lexer.ttype + " (" + this.lexer.render() + ")");
        if (this.lexer.ttype == -3 && this.lexer.sval.indexOf(46) == -1) {
            throw new CQLParseException("unknown first-class relation: " + this.lexer.sval);
        }
        if (this.isProxRelation()) return true;
        if (this.lexer.ttype == CQLLexer.TT_ANY) return true;
        if (this.lexer.ttype == CQLLexer.TT_ALL) return true;
        if (this.lexer.ttype == CQLLexer.TT_EXACT) return true;
        if (this.lexer.ttype == CQLLexer.TT_SCR) return true;
        if (this.lexer.ttype != -3) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isProxRelation() {
        CQLParser.debug("isProxRelation: checking ttype=" + this.lexer.ttype + " (" + this.lexer.render() + ")");
        if (this.lexer.ttype == 60) return true;
        if (this.lexer.ttype == 62) return true;
        if (this.lexer.ttype == 61) return true;
        if (this.lexer.ttype == CQLLexer.TT_LE) return true;
        if (this.lexer.ttype == CQLLexer.TT_GE) return true;
        if (this.lexer.ttype != CQLLexer.TT_NE) return false;
        return true;
    }

    private void match(int n) throws CQLParseException, IOException {
        CQLParser.debug("in match(" + this.lexer.render(n, true) + ")");
        if (this.lexer.ttype != n) {
            throw new CQLParseException("expected " + this.lexer.render(n, true) + ", " + "got " + this.lexer.render());
        }
        int n2 = this.lexer.nextToken();
        CQLParser.debug("match() got token=" + this.lexer.ttype + ", " + "nval=" + this.lexer.nval + ", sval='" + this.lexer.sval + "'" + " (tmp=" + n2 + ")");
    }

    private String matchSymbol(String string) throws CQLParseException, IOException {
        block3: {
            block2: {
                CQLParser.debug("in matchSymbol()");
                if (this.lexer.ttype == -3) break block2;
                if (this.lexer.ttype == -2 || this.lexer.ttype == 34) break block2;
                if (this.lexer.ttype == CQLLexer.TT_AND) break block2;
                if (this.lexer.ttype == CQLLexer.TT_OR) break block2;
                if (this.lexer.ttype == CQLLexer.TT_NOT) break block2;
                if (this.lexer.ttype == CQLLexer.TT_PROX) break block2;
                if (this.lexer.ttype == CQLLexer.TT_ANY) break block2;
                if (this.lexer.ttype == CQLLexer.TT_ALL) break block2;
                if (this.lexer.ttype == CQLLexer.TT_EXACT) break block2;
                if (this.lexer.ttype == CQLLexer.TT_pWORD) break block2;
                if (this.lexer.ttype == CQLLexer.TT_SENTENCE) break block2;
                if (this.lexer.ttype == CQLLexer.TT_PARAGRAPH) break block2;
                if (this.lexer.ttype == CQLLexer.TT_ELEMENT) break block2;
                if (this.lexer.ttype == CQLLexer.TT_ORDERED) break block2;
                if (this.lexer.ttype == CQLLexer.TT_UNORDERED) break block2;
                if (this.lexer.ttype == CQLLexer.TT_RELEVANT) break block2;
                if (this.lexer.ttype == CQLLexer.TT_FUZZY) break block2;
                if (this.lexer.ttype == CQLLexer.TT_STEM) break block2;
                if (this.lexer.ttype == CQLLexer.TT_SCR) break block2;
                if (this.lexer.ttype != CQLLexer.TT_PHONETIC) break block3;
            }
            String string2 = this.lexer.ttype == -2 ? this.lexer.render() : this.lexer.sval;
            this.match(this.lexer.ttype);
            return string2;
        }
        throw new CQLParseException("expected " + string + ", " + "got " + this.lexer.render());
    }

    public static void main(String[] stringArray) {
        Object object;
        String string;
        int n = 120;
        String string2 = null;
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        if (vector.size() > 0 && vector.get(0).equals("-c")) {
            n = 99;
            vector.remove(0);
        } else if (vector.size() > 1 && vector.get(0).equals("-p")) {
            n = 112;
            vector.remove(0);
            string2 = (String)vector.get(0);
            vector.remove(0);
        }
        if (vector.size() > 1) {
            System.err.println("Usage: CQLParser [-c] [-p <pqf-properties> [<CQL-query>]");
            System.err.println("If unspecified, query is read from stdin");
            System.exit(1);
        }
        if (vector.size() == 1) {
            string = (String)vector.get(0);
        } else {
            object = new byte[10000];
            try {
                int n2 = System.in.read((byte[])object);
            }
            catch (IOException iOException) {
                System.err.println("Can't read query: " + iOException.getMessage());
                System.exit(2);
            }
            string = new String((byte[])object);
        }
        object = new CQLParser();
        CQLNode cQLNode = null;
        try {
            cQLNode = ((CQLParser)object).parse(string);
        }
        catch (CQLParseException cQLParseException) {
            System.err.println("Syntax error: " + cQLParseException.getMessage());
            System.exit(3);
        }
        catch (IOException iOException) {
            System.err.println("Can't compile query: " + iOException.getMessage());
            System.exit(4);
        }
        try {
            if (n == 99) {
                System.out.println(cQLNode.toCQL());
            } else if (n == 112) {
                FileInputStream fileInputStream = new FileInputStream(string2);
                if (fileInputStream == null) {
                    throw new FileNotFoundException(string2);
                }
                Properties properties = new Properties();
                properties.load(fileInputStream);
                ((InputStream)fileInputStream).close();
                System.out.println(cQLNode.toPQF(properties));
            } else {
                System.out.print(cQLNode.toXCQL(0));
            }
        }
        catch (IOException iOException) {
            System.err.println("Can't render query: " + iOException.getMessage());
            System.exit(5);
        }
        catch (UnknownQualifierException unknownQualifierException) {
            System.err.println("Unknown qualifier: " + unknownQualifierException.getMessage());
            System.exit(6);
        }
        catch (UnknownRelationException unknownRelationException) {
            System.err.println("Unknown relation: " + unknownRelationException.getMessage());
            System.exit(7);
        }
        catch (UnknownRelationModifierException unknownRelationModifierException) {
            System.err.println("Unknown relation modifier: " + unknownRelationModifierException.getMessage());
            System.exit(8);
        }
        catch (UnknownPositionException unknownPositionException) {
            System.err.println("Unknown position: " + unknownPositionException.getMessage());
            System.exit(9);
        }
        catch (PQFTranslationException pQFTranslationException) {
            throw new Error("can't get a PQFTranslationException");
        }
    }
}

