/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.FunctionTypeI;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TypeI;
import com.google.javascript.rhino.jstype.ArrowType;
import com.google.javascript.rhino.jstype.EquivalenceMethod;
import com.google.javascript.rhino.jstype.FunctionBuilder;
import com.google.javascript.rhino.jstype.FunctionParamBuilder;
import com.google.javascript.rhino.jstype.InstanceObjectType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.Property;
import com.google.javascript.rhino.jstype.PrototypeObjectType;
import com.google.javascript.rhino.jstype.RelationshipVisitor;
import com.google.javascript.rhino.jstype.StaticTypedScope;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.UnknownType;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class FunctionType
extends PrototypeObjectType
implements FunctionTypeI {
    private static final long serialVersionUID = 1L;
    private ArrowType call;
    private Property prototypeSlot;
    private final Kind kind;
    private PropAccess propAccess;
    private JSType typeOfThis;
    private Node source;
    private ImmutableList<ObjectType> implementedInterfaces = ImmutableList.of();
    private ImmutableList<ObjectType> extendedInterfaces = ImmutableList.of();
    private List<FunctionType> subTypes;

    FunctionType(JSTypeRegistry registry, String name, Node source, ArrowType arrowType, JSType typeOfThis, TemplateTypeMap templateTypeMap, boolean isConstructor, boolean nativeType) {
        super(registry, name, registry.getNativeObjectType(JSTypeNative.FUNCTION_INSTANCE_TYPE), nativeType, templateTypeMap);
        this.setPrettyPrint(true);
        Preconditions.checkArgument((source == null || 105 == source.getType() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)arrowType);
        this.source = source;
        if (isConstructor) {
            this.kind = Kind.CONSTRUCTOR;
            this.propAccess = PropAccess.ANY;
            this.typeOfThis = typeOfThis != null ? typeOfThis : new InstanceObjectType(registry, this, nativeType);
        } else {
            this.kind = Kind.ORDINARY;
            this.typeOfThis = typeOfThis != null ? typeOfThis : registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE);
        }
        this.call = arrowType;
    }

    private FunctionType(JSTypeRegistry registry, String name, Node source, TemplateTypeMap typeParameters) {
        super(registry, name, registry.getNativeObjectType(JSTypeNative.FUNCTION_INSTANCE_TYPE), false, typeParameters);
        this.setPrettyPrint(true);
        Preconditions.checkArgument((source == null || 105 == source.getType() ? 1 : 0) != 0);
        Preconditions.checkArgument((name != null ? 1 : 0) != 0);
        this.source = source;
        this.call = new ArrowType(registry, new Node(83), null);
        this.kind = Kind.INTERFACE;
        this.typeOfThis = new InstanceObjectType(registry, this);
    }

    static FunctionType forInterface(JSTypeRegistry registry, String name, Node source, TemplateTypeMap typeParameters) {
        return new FunctionType(registry, name, source, typeParameters);
    }

    @Override
    public boolean isInstanceType() {
        return this == this.registry.getNativeType(JSTypeNative.U2U_CONSTRUCTOR_TYPE);
    }

    @Override
    public boolean isConstructor() {
        return this.kind == Kind.CONSTRUCTOR;
    }

    @Override
    public boolean isInterface() {
        return this.kind == Kind.INTERFACE;
    }

    @Override
    public boolean isOrdinaryFunction() {
        return this.kind == Kind.ORDINARY;
    }

    public boolean makesStructs() {
        if (!this.isConstructor()) {
            return false;
        }
        if (this.propAccess == PropAccess.STRUCT) {
            return true;
        }
        FunctionType superc = this.getSuperClassConstructor();
        if (superc != null && superc.makesStructs()) {
            this.setStruct();
            return true;
        }
        return false;
    }

    public boolean makesDicts() {
        if (!this.isConstructor()) {
            return false;
        }
        if (this.propAccess == PropAccess.DICT) {
            return true;
        }
        FunctionType superc = this.getSuperClassConstructor();
        if (superc != null && superc.makesDicts()) {
            this.setDict();
            return true;
        }
        return false;
    }

    public void setStruct() {
        this.propAccess = PropAccess.STRUCT;
    }

    public void setDict() {
        this.propAccess = PropAccess.DICT;
    }

    @Override
    public FunctionType toMaybeFunctionType() {
        return this;
    }

    @Override
    public boolean canBeCalled() {
        return true;
    }

    public boolean hasImplementedInterfaces() {
        FunctionType superCtor;
        if (!this.implementedInterfaces.isEmpty()) {
            return true;
        }
        FunctionType functionType = superCtor = this.isConstructor() ? this.getSuperClassConstructor() : null;
        if (superCtor != null) {
            return superCtor.hasImplementedInterfaces();
        }
        return false;
    }

    public Iterable<Node> getParameters() {
        Node n = this.getParametersNode();
        if (n != null) {
            return n.children();
        }
        return Collections.emptySet();
    }

    public Node getParametersNode() {
        return this.call.parameters;
    }

    public int getMinArguments() {
        int i = 0;
        int min = 0;
        for (Node n : this.getParameters()) {
            ++i;
            if (n.isOptionalArg() || n.isVarArgs()) continue;
            min = i;
        }
        return min;
    }

    public int getMaxArguments() {
        Node lastParam;
        Node params = this.getParametersNode();
        if (!(params == null || (lastParam = params.getLastChild()) != null && lastParam.isVarArgs())) {
            return params.getChildCount();
        }
        return Integer.MAX_VALUE;
    }

    public JSType getReturnType() {
        return this.call.returnType;
    }

    public boolean isReturnTypeInferred() {
        return this.call.returnTypeInferred;
    }

    ArrowType getInternalArrowType() {
        return this.call;
    }

    @Override
    public Property getSlot(String name) {
        if ("prototype".equals(name)) {
            this.getPrototype();
            return this.prototypeSlot;
        }
        return super.getSlot(name);
    }

    @Override
    public Set<String> getOwnPropertyNames() {
        if (this.prototypeSlot == null) {
            return super.getOwnPropertyNames();
        }
        HashSet<String> names = new HashSet<String>();
        names.add("prototype");
        names.addAll(super.getOwnPropertyNames());
        return names;
    }

    public ObjectType getPrototype() {
        if (this.prototypeSlot == null) {
            String refName = this.getReferenceName();
            if (refName == null) {
                this.setPrototypeNoCheck(this.registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE), null);
            } else {
                this.setPrototype(new PrototypeObjectType(this.registry, this.getReferenceName() + ".prototype", this.registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE), this.isNativeObjectType(), null), null);
            }
        }
        return (ObjectType)this.prototypeSlot.getType();
    }

    public void setPrototypeBasedOn(ObjectType baseType) {
        this.setPrototypeBasedOn(baseType, null);
    }

    void setPrototypeBasedOn(ObjectType baseType, Node propertyNode) {
        if (baseType.hasReferenceName() || this.isNativeObjectType() || baseType.isFunctionPrototypeType()) {
            baseType = new PrototypeObjectType(this.registry, this.getReferenceName() + ".prototype", baseType);
        }
        this.setPrototype(baseType, propertyNode);
    }

    public void extendTemplateTypeMapBasedOn(ObjectType type) {
        this.typeOfThis.extendTemplateTypeMap(type.getTemplateTypeMap());
    }

    boolean setPrototype(ObjectType prototype, Node propertyNode) {
        if (prototype == null) {
            return false;
        }
        if (this.isConstructor() && prototype == this.getInstanceType()) {
            return false;
        }
        return this.setPrototypeNoCheck(prototype, propertyNode);
    }

    private boolean setPrototypeNoCheck(ObjectType prototype, Node propertyNode) {
        ObjectType oldPrototype = this.prototypeSlot == null ? null : (ObjectType)this.prototypeSlot.getType();
        boolean replacedPrototype = oldPrototype != null;
        this.prototypeSlot = new Property("prototype", prototype, true, propertyNode == null ? this.source : propertyNode);
        prototype.setOwnerFunction(this);
        if (oldPrototype != null) {
            oldPrototype.setOwnerFunction(null);
        }
        if (this.isConstructor() || this.isInterface()) {
            FunctionType superClass = this.getSuperClassConstructor();
            if (superClass != null) {
                superClass.addSubType(this);
            }
            if (this.isInterface()) {
                for (ObjectType interfaceType : this.getExtendedInterfaces()) {
                    if (interfaceType.getConstructor() == null) continue;
                    interfaceType.getConstructor().addSubType(this);
                }
            }
        }
        if (replacedPrototype) {
            this.clearCachedValues();
        }
        return true;
    }

    public Iterable<ObjectType> getAllImplementedInterfaces() {
        LinkedHashSet<ObjectType> interfaces = new LinkedHashSet<ObjectType>();
        for (ObjectType type : this.getImplementedInterfaces()) {
            this.addRelatedInterfaces(type, interfaces);
        }
        return interfaces;
    }

    private void addRelatedInterfaces(ObjectType instance, Set<ObjectType> set) {
        FunctionType constructor = instance.getConstructor();
        if (constructor != null) {
            if (!constructor.isInterface()) {
                return;
            }
            if (!set.add(instance)) {
                return;
            }
            for (ObjectType interfaceType : instance.getCtorExtendedInterfaces()) {
                this.addRelatedInterfaces(interfaceType, set);
            }
        }
    }

    public Iterable<ObjectType> getImplementedInterfaces() {
        FunctionType superCtor;
        FunctionType functionType = superCtor = this.isConstructor() ? this.getSuperClassConstructor() : null;
        if (superCtor == null) {
            return this.implementedInterfaces;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.implementedInterfaces);
        while (superCtor != null) {
            builder.addAll(superCtor.implementedInterfaces);
            superCtor = superCtor.getSuperClassConstructor();
        }
        return builder.build();
    }

    public Iterable<ObjectType> getOwnImplementedInterfaces() {
        return this.implementedInterfaces;
    }

    public void setImplementedInterfaces(List<ObjectType> implementedInterfaces) {
        if (this.isConstructor()) {
            for (ObjectType type : implementedInterfaces) {
                this.registry.registerTypeImplementingInterface(this, type);
                this.typeOfThis.extendTemplateTypeMap(type.getTemplateTypeMap());
            }
        } else {
            throw new UnsupportedOperationException();
        }
        this.implementedInterfaces = ImmutableList.copyOf(implementedInterfaces);
    }

    public Iterable<ObjectType> getAllExtendedInterfaces() {
        LinkedHashSet<ObjectType> extendedInterfaces = new LinkedHashSet<ObjectType>();
        for (ObjectType interfaceType : this.getExtendedInterfaces()) {
            this.addRelatedExtendedInterfaces(interfaceType, extendedInterfaces);
        }
        return extendedInterfaces;
    }

    private void addRelatedExtendedInterfaces(ObjectType instance, Set<ObjectType> set) {
        FunctionType constructor = instance.getConstructor();
        if (constructor != null) {
            if (!set.add(instance)) {
                return;
            }
            for (ObjectType interfaceType : constructor.getExtendedInterfaces()) {
                this.addRelatedExtendedInterfaces(interfaceType, set);
            }
        }
    }

    public Iterable<ObjectType> getExtendedInterfaces() {
        return this.extendedInterfaces;
    }

    public int getExtendedInterfacesCount() {
        return this.extendedInterfaces.size();
    }

    public void setExtendedInterfaces(List<ObjectType> extendedInterfaces) throws UnsupportedOperationException {
        if (this.isInterface()) {
            this.extendedInterfaces = ImmutableList.copyOf(extendedInterfaces);
            for (ObjectType extendedInterface : this.extendedInterfaces) {
                this.typeOfThis.extendTemplateTypeMap(extendedInterface.getTemplateTypeMap());
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public JSType getPropertyType(String name) {
        if (!this.hasOwnProperty(name)) {
            boolean isCall = "call".equals(name);
            boolean isBind = "bind".equals(name);
            if (isCall || isBind) {
                this.defineDeclaredProperty(name, this.getCallOrBindSignature(isCall), this.source);
            } else if ("apply".equals(name)) {
                FunctionParamBuilder builder = new FunctionParamBuilder(this.registry);
                builder.addOptionalParams(this.registry.createNullableType(this.getTypeOfThis()), this.registry.createNullableType(this.registry.getNativeType(JSTypeNative.OBJECT_TYPE)));
                this.defineDeclaredProperty(name, new FunctionBuilder(this.registry).withParamsNode(builder.build()).withReturnType(this.getReturnType()).withTemplateKeys(this.getTemplateTypeMap().getTemplateKeys()).build(), this.source);
            }
        }
        return super.getPropertyType(name);
    }

    public FunctionType getBindReturnType(int argsToBind) {
        Node origParams;
        FunctionBuilder builder = new FunctionBuilder(this.registry).withReturnType(this.getReturnType()).withTemplateKeys(this.getTemplateTypeMap().getTemplateKeys());
        if (argsToBind >= 0 && (origParams = this.getParametersNode()) != null) {
            Node params = origParams.cloneTree();
            for (int i = 1; i < argsToBind && params.getFirstChild() != null && !params.getFirstChild().isVarArgs(); ++i) {
                params.removeFirstChild();
            }
            builder.withParamsNode(params);
        }
        return builder.build();
    }

    private FunctionType getCallOrBindSignature(boolean isCall) {
        boolean isBind = !isCall;
        FunctionBuilder builder = new FunctionBuilder(this.registry).withReturnType(isCall ? this.getReturnType() : this.getBindReturnType(-1)).withTemplateKeys(this.getTemplateTypeMap().getTemplateKeys());
        Node origParams = this.getParametersNode();
        if (origParams != null) {
            Node firstArg;
            Node params = origParams.cloneTree();
            Node thisTypeNode = Node.newString(38, "thisType");
            thisTypeNode.setJSType(this.registry.createOptionalNullableType(this.getTypeOfThis()));
            params.addChildToFront(thisTypeNode);
            if (isBind) {
                for (Node current = thisTypeNode.getNext(); current != null; current = current.getNext()) {
                    current.setOptionalArg(true);
                }
            } else if (isCall && ((firstArg = thisTypeNode.getNext()) == null || firstArg.isOptionalArg() || firstArg.isVarArgs())) {
                thisTypeNode.setOptionalArg(true);
            }
            builder.withParamsNode(params);
        }
        return builder.build();
    }

    @Override
    boolean defineProperty(String name, JSType type, boolean inferred, Node propertyNode) {
        if ("prototype".equals(name)) {
            ObjectType objType = type.toObjectType();
            if (objType != null) {
                if (this.prototypeSlot != null && objType.isEquivalentTo(this.prototypeSlot.getType())) {
                    return true;
                }
                this.setPrototypeBasedOn(objType, propertyNode);
                return true;
            }
            return false;
        }
        return super.defineProperty(name, type, inferred, propertyNode);
    }

    FunctionType supAndInfHelper(FunctionType that, boolean leastSuper) {
        JSType functionInstance;
        Preconditions.checkNotNull((Object)that);
        if (this.isEquivalentTo(that)) {
            return this;
        }
        if (this.isOrdinaryFunction() && that.isOrdinaryFunction() && !this.call.hasUnknownParamsOrReturn() && !that.call.hasUnknownParamsOrReturn()) {
            boolean isSubtypeOfThat = this.isSubtype(that);
            boolean isSubtypeOfThis = that.isSubtype(this);
            if (isSubtypeOfThat && !isSubtypeOfThis) {
                return leastSuper ? that : this;
            }
            if (isSubtypeOfThis && !isSubtypeOfThat) {
                return leastSuper ? this : that;
            }
            FunctionType merged = this.tryMergeFunctionPiecewise(that, leastSuper);
            if (merged != null) {
                return merged;
            }
        }
        if ((functionInstance = this.registry.getNativeType(JSTypeNative.FUNCTION_INSTANCE_TYPE)).isEquivalentTo(that)) {
            return leastSuper ? that : this;
        }
        if (functionInstance.isEquivalentTo(this)) {
            return leastSuper ? this : that;
        }
        FunctionType greatestFn = this.registry.getNativeFunctionType(JSTypeNative.U2U_CONSTRUCTOR_TYPE);
        FunctionType leastFn = this.registry.getNativeFunctionType(JSTypeNative.LEAST_FUNCTION_TYPE);
        return leastSuper ? greatestFn : leastFn;
    }

    private FunctionType tryMergeFunctionPiecewise(FunctionType other, boolean leastSuper) {
        JSType maybeNewTypeOfThis;
        Node newParamsNode = null;
        if (!this.call.hasEqualParameters(other.call, EquivalenceMethod.IDENTITY)) {
            return null;
        }
        newParamsNode = this.call.parameters;
        JSType newReturnType = leastSuper ? this.call.returnType.getLeastSupertype(other.call.returnType) : this.call.returnType.getGreatestSubtype(other.call.returnType);
        JSType newTypeOfThis = null;
        newTypeOfThis = FunctionType.isEquivalent(this.typeOfThis, other.typeOfThis) ? this.typeOfThis : (maybeNewTypeOfThis = leastSuper ? this.typeOfThis.getLeastSupertype(other.typeOfThis) : this.typeOfThis.getGreatestSubtype(other.typeOfThis));
        boolean newReturnTypeInferred = this.call.returnTypeInferred || other.call.returnTypeInferred;
        return new FunctionType(this.registry, null, null, new ArrowType(this.registry, newParamsNode, newReturnType, newReturnTypeInferred), newTypeOfThis, null, false, false);
    }

    public FunctionType getSuperClassConstructor() {
        Preconditions.checkArgument((this.isConstructor() || this.isInterface() ? 1 : 0) != 0);
        ObjectType maybeSuperInstanceType = this.getPrototype().getImplicitPrototype();
        if (maybeSuperInstanceType == null) {
            return null;
        }
        return maybeSuperInstanceType.getConstructor();
    }

    public static ObjectType getTopDefiningInterface(ObjectType type, String propertyName) {
        ObjectType foundType = null;
        if (type.hasProperty(propertyName)) {
            foundType = type;
        }
        for (ObjectType interfaceType : type.getCtorExtendedInterfaces()) {
            if (!interfaceType.hasProperty(propertyName)) continue;
            foundType = FunctionType.getTopDefiningInterface(interfaceType, propertyName);
        }
        return foundType;
    }

    public ObjectType getTopMostDefiningType(String propertyName) {
        Preconditions.checkState((this.isConstructor() || this.isInterface() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)this.getInstanceType().hasProperty(propertyName));
        FunctionType ctor = this;
        if (this.isInterface()) {
            return FunctionType.getTopDefiningInterface(this.getInstanceType(), propertyName);
        }
        ObjectType topInstanceType = null;
        do {
            topInstanceType = ctor.getInstanceType();
        } while ((ctor = ctor.getSuperClassConstructor()) != null && ctor.getPrototype().hasProperty(propertyName));
        return topInstanceType;
    }

    boolean checkFunctionEquivalenceHelper(FunctionType that, EquivalenceMethod eqMethod) {
        if (this.isConstructor()) {
            if (that.isConstructor()) {
                return this == that;
            }
            return false;
        }
        if (this.isInterface()) {
            if (that.isInterface()) {
                return this.getReferenceName().equals(that.getReferenceName());
            }
            return false;
        }
        if (that.isInterface()) {
            return false;
        }
        return this.typeOfThis.checkEquivalenceHelper(that.typeOfThis, eqMethod) && this.call.checkArrowEquivalenceHelper(that.call, eqMethod);
    }

    @Override
    public int hashCode() {
        return this.isInterface() ? this.getReferenceName().hashCode() : this.call.hashCode();
    }

    public boolean hasEqualCallType(FunctionType otherType) {
        return this.call.checkArrowEquivalenceHelper(otherType.call, EquivalenceMethod.IDENTITY);
    }

    @Override
    String toStringHelper(boolean forAnnotations) {
        boolean hasKnownTypeOfThis;
        if (!this.isPrettyPrint() || this == this.registry.getNativeType(JSTypeNative.FUNCTION_INSTANCE_TYPE)) {
            return "Function";
        }
        this.setPrettyPrint(false);
        StringBuilder b = new StringBuilder(32);
        b.append("function (");
        int paramNum = this.call.parameters.getChildCount();
        boolean bl = hasKnownTypeOfThis = !(this.typeOfThis instanceof UnknownType);
        if (hasKnownTypeOfThis) {
            if (this.isConstructor()) {
                b.append("new:");
            } else {
                b.append("this:");
            }
            b.append(this.typeOfThis.toStringHelper(forAnnotations));
        }
        if (paramNum > 0) {
            if (hasKnownTypeOfThis) {
                b.append(", ");
            }
            Node p = this.call.parameters.getFirstChild();
            this.appendArgString(b, p, forAnnotations);
            for (p = p.getNext(); p != null; p = p.getNext()) {
                b.append(", ");
                this.appendArgString(b, p, forAnnotations);
            }
        }
        b.append("): ");
        b.append(this.call.returnType.toStringHelper(forAnnotations));
        this.setPrettyPrint(true);
        return b.toString();
    }

    private void appendArgString(StringBuilder b, Node p, boolean forAnnotations) {
        if (p.isVarArgs()) {
            this.appendVarArgsString(b, p.getJSType(), forAnnotations);
        } else if (p.isOptionalArg()) {
            this.appendOptionalArgString(b, p.getJSType(), forAnnotations);
        } else {
            b.append(p.getJSType().toStringHelper(forAnnotations));
        }
    }

    private void appendVarArgsString(StringBuilder builder, JSType paramType, boolean forAnnotations) {
        if (paramType.isUnionType()) {
            paramType = paramType.toMaybeUnionType().getRestrictedUnion(this.registry.getNativeType(JSTypeNative.VOID_TYPE));
        }
        builder.append("...").append(paramType.toStringHelper(forAnnotations));
    }

    private void appendOptionalArgString(StringBuilder builder, JSType paramType, boolean forAnnotations) {
        if (paramType.isUnionType()) {
            paramType = paramType.toMaybeUnionType().getRestrictedUnion(this.registry.getNativeType(JSTypeNative.VOID_TYPE));
        }
        builder.append(paramType.toStringHelper(forAnnotations)).append("=");
    }

    @Override
    public boolean isSubtype(JSType that) {
        if (JSType.isSubtypeHelper(this, that)) {
            return true;
        }
        if (that.isFunctionType()) {
            FunctionType other = that.toMaybeFunctionType();
            if (other.isInterface()) {
                return true;
            }
            if (this.isInterface()) {
                return false;
            }
            boolean treatThisTypesAsCovariant = other.typeOfThis.toObjectType() != null && other.typeOfThis.toObjectType().getConstructor() != null && other.typeOfThis.toObjectType().getConstructor().isInterface() || other.typeOfThis.isSubtype(this.typeOfThis) || this.typeOfThis.isSubtype(other.typeOfThis);
            return treatThisTypesAsCovariant && this.call.isSubtype(other.call);
        }
        return this.getNativeType(JSTypeNative.FUNCTION_PROTOTYPE).isSubtype(that);
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseFunctionType(this);
    }

    @Override
    <T> T visit(RelationshipVisitor<T> visitor, JSType that) {
        return visitor.caseFunctionType(this, that);
    }

    @Override
    public ObjectType getInstanceType() {
        Preconditions.checkState((boolean)this.hasInstanceType());
        return this.typeOfThis.toObjectType();
    }

    void setInstanceType(ObjectType instanceType) {
        this.typeOfThis = instanceType;
    }

    public boolean hasInstanceType() {
        return this.isConstructor() || this.isInterface();
    }

    @Override
    public JSType getTypeOfThis() {
        return this.typeOfThis.isEmptyType() ? this.registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE) : this.typeOfThis;
    }

    @Override
    public Node getSource() {
        return this.source;
    }

    @Override
    public void setSource(Node source) {
        if (this.prototypeSlot != null && (source == null || this.prototypeSlot.getNode() == null)) {
            this.prototypeSlot = new Property(this.prototypeSlot.getName(), this.prototypeSlot.getType(), this.prototypeSlot.isTypeInferred(), source);
        }
        this.source = source;
    }

    private void addSubType(FunctionType subType) {
        if (this.subTypes == null) {
            this.subTypes = new ArrayList<FunctionType>();
        }
        this.subTypes.add(subType);
    }

    @Override
    public void clearCachedValues() {
        super.clearCachedValues();
        if (this.subTypes != null) {
            for (FunctionType subType : this.subTypes) {
                subType.clearCachedValues();
            }
        }
        if (!this.isNativeObjectType()) {
            if (this.hasInstanceType()) {
                this.getInstanceType().clearCachedValues();
            }
            if (this.prototypeSlot != null) {
                ((ObjectType)this.prototypeSlot.getType()).clearCachedValues();
            }
        }
    }

    public List<FunctionType> getSubTypes() {
        return this.subTypes;
    }

    @Override
    public boolean hasCachedValues() {
        return this.prototypeSlot != null || super.hasCachedValues();
    }

    @Override
    JSType resolveInternal(ErrorReporter t, StaticTypedScope<JSType> scope) {
        ImmutableList<ObjectType> resolvedExtended;
        ImmutableList<ObjectType> resolvedImplemented;
        JSType maybeTypeOfThis;
        this.setResolvedTypeInternal(this);
        this.call = (ArrowType)FunctionType.safeResolve(this.call, t, scope);
        if (this.prototypeSlot != null) {
            this.prototypeSlot.setType(FunctionType.safeResolve(this.prototypeSlot.getType(), t, scope));
        }
        if ((maybeTypeOfThis = FunctionType.safeResolve(this.typeOfThis, t, scope)) != null) {
            if (maybeTypeOfThis.isNullType() || maybeTypeOfThis.isVoidType()) {
                this.typeOfThis = maybeTypeOfThis;
            } else if ((maybeTypeOfThis = ObjectType.cast(maybeTypeOfThis.restrictByNotNullOrUndefined())) != null) {
                this.typeOfThis = maybeTypeOfThis;
            }
        }
        if ((resolvedImplemented = this.resolveTypeListHelper(this.implementedInterfaces, t, scope)) != null) {
            this.implementedInterfaces = resolvedImplemented;
        }
        if ((resolvedExtended = this.resolveTypeListHelper(this.extendedInterfaces, t, scope)) != null) {
            this.extendedInterfaces = resolvedExtended;
        }
        if (this.subTypes != null) {
            for (int i = 0; i < this.subTypes.size(); ++i) {
                this.subTypes.set(i, JSType.toMaybeFunctionType(this.subTypes.get(i).resolve(t, scope)));
            }
        }
        return super.resolveInternal(t, scope);
    }

    private ImmutableList<ObjectType> resolveTypeListHelper(ImmutableList<ObjectType> list, ErrorReporter t, StaticTypedScope<JSType> scope) {
        boolean changed = false;
        ImmutableList.Builder resolvedList = ImmutableList.builder();
        for (ObjectType type : list) {
            ObjectType resolved = (ObjectType)type.resolve(t, scope);
            resolvedList.add((Object)resolved);
            changed |= resolved != type;
        }
        return changed ? resolvedList.build() : null;
    }

    @Override
    public String toDebugHashCodeString() {
        boolean hasKnownTypeOfThis;
        if (this == this.registry.getNativeType(JSTypeNative.FUNCTION_INSTANCE_TYPE)) {
            return super.toDebugHashCodeString();
        }
        StringBuilder b = new StringBuilder(32);
        b.append("function (");
        int paramNum = this.call.parameters.getChildCount();
        boolean bl = hasKnownTypeOfThis = !this.typeOfThis.isUnknownType();
        if (hasKnownTypeOfThis) {
            b.append("this:");
            b.append(this.getDebugHashCodeStringOf(this.typeOfThis));
        }
        if (paramNum > 0) {
            if (hasKnownTypeOfThis) {
                b.append(", ");
            }
            Node p = this.call.parameters.getFirstChild();
            b.append(this.getDebugHashCodeStringOf(p.getJSType()));
            for (p = p.getNext(); p != null; p = p.getNext()) {
                b.append(", ");
                b.append(this.getDebugHashCodeStringOf(p.getJSType()));
            }
        }
        b.append(")");
        b.append(": ");
        b.append(this.getDebugHashCodeStringOf(this.call.returnType));
        return b.toString();
    }

    private String getDebugHashCodeStringOf(JSType type) {
        if (type == this) {
            return "me";
        }
        return type.toDebugHashCodeString();
    }

    public FunctionType forgetParameterAndReturnTypes() {
        FunctionType result = new FunctionType(this.registry, this.getReferenceName(), this.source, this.registry.createArrowType(null, null), this.getInstanceType(), null, true, false);
        result.setPrototypeBasedOn(this.getInstanceType());
        return result;
    }

    @Override
    public boolean hasAnyTemplateTypesInternal() {
        return this.getTemplateTypeMap().numUnfilledTemplateKeys() > 0 || this.typeOfThis.hasAnyTemplateTypes() || this.call.hasAnyTemplateTypes();
    }

    @Override
    public TypeI convertMethodToFunction() {
        ArrayList<JSType> paramTypes = new ArrayList<JSType>();
        paramTypes.add(this.getTypeOfThis());
        for (Node param : this.getParameters()) {
            paramTypes.add(param.getJSType());
        }
        return this.registry.createFunctionTypeWithInstanceType(this.registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE), this.getReturnType(), paramTypes);
    }

    @Override
    public boolean hasProperties() {
        if (this.prototypeSlot != null) {
            return true;
        }
        return !super.getOwnPropertyNames().isEmpty();
    }

    private static enum PropAccess {
        ANY,
        STRUCT,
        DICT;

    }

    private static enum Kind {
        ORDINARY,
        CONSTRUCTOR,
        INTERFACE;

    }
}

