/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.web;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public abstract class WebappMetricsFilter
implements Filter {
    private final ConcurrentMap<Integer, Meter> metersByStatusCode;
    private final Meter otherMeter;
    private final Counter activeRequests;
    private final Timer requestTimer;

    public WebappMetricsFilter(Map<Integer, String> meterNamesByStatusCode, String otherMetricName) {
        this.metersByStatusCode = new ConcurrentHashMap<Integer, Meter>(meterNamesByStatusCode.size());
        for (Map.Entry<Integer, String> entry : meterNamesByStatusCode.entrySet()) {
            this.metersByStatusCode.put(entry.getKey(), Metrics.newMeter(WebappMetricsFilter.class, (String)entry.getValue(), (String)"responses", (TimeUnit)TimeUnit.SECONDS));
        }
        this.otherMeter = Metrics.newMeter(WebappMetricsFilter.class, (String)otherMetricName, (String)"responses", (TimeUnit)TimeUnit.SECONDS);
        this.activeRequests = Metrics.newCounter(WebappMetricsFilter.class, (String)"activeRequests");
        this.requestTimer = Metrics.newTimer(WebappMetricsFilter.class, (String)"requests", (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.SECONDS);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        StatusExposingServletResponse wrappedResponse = new StatusExposingServletResponse((HttpServletResponse)response);
        this.activeRequests.inc();
        TimerContext context = this.requestTimer.time();
        try {
            chain.doFilter(request, (ServletResponse)wrappedResponse);
        }
        finally {
            context.stop();
            this.activeRequests.dec();
            this.markMeterForStatusCode(wrappedResponse.getStatus());
        }
    }

    private void markMeterForStatusCode(int status) {
        Meter metric = (Meter)this.metersByStatusCode.get(status);
        if (metric != null) {
            metric.mark();
        } else {
            this.otherMeter.mark();
        }
    }

    private static class StatusExposingServletResponse
    extends HttpServletResponseWrapper {
        private int httpStatus;

        public StatusExposingServletResponse(HttpServletResponse response) {
            super(response);
        }

        public void sendError(int sc) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc, msg);
        }

        public void setStatus(int sc) {
            this.httpStatus = sc;
            super.setStatus(sc);
        }

        public int getStatus() {
            return this.httpStatus;
        }
    }
}

