/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters.groovy.template;

import com.google.common.base.Optional;
import java.io.IOException;
import org.fao.geonet.SystemInfo;
import org.fao.geonet.api.records.formatters.groovy.Handlers;
import org.fao.geonet.api.records.formatters.groovy.TransformationContext;
import org.fao.geonet.api.records.formatters.groovy.template.AttributesFiltered;
import org.fao.geonet.api.records.formatters.groovy.template.FileResult;
import org.fao.geonet.api.records.formatters.groovy.template.TNode;
import org.fao.geonet.api.records.formatters.groovy.template.TNodeFactoryByAttName;
import org.fao.geonet.api.records.formatters.groovy.template.TRenderContext;
import org.fao.geonet.api.records.formatters.groovy.template.TextContentParser;
import org.springframework.stereotype.Component;
import org.xml.sax.Attributes;

@Component
public class TNodeFactoryInclude
extends TNodeFactoryByAttName {
    private static final String INCLUDE = "include";
    private static final String REPLACE = "include-replace";

    protected TNodeFactoryInclude() {
        super(INCLUDE, null);
    }

    public TNodeFactoryInclude(SystemInfo info, TextContentParser contentParser) {
        super(INCLUDE, info);
        this.textContentParser = contentParser;
    }

    @Override
    public TNode create(String localName, String qName, Attributes attributes) throws IOException {
        AttributesFiltered filteredAtts = new AttributesFiltered(attributes, INCLUDE, REPLACE);
        String templatePath = this.getValue(attributes, INCLUDE);
        boolean replace = this.getBooleanAttribute(attributes, REPLACE, false);
        return new TNodeInclude(SystemInfo.getInfo((SystemInfo)this.testingInfo), this.textContentParser, qName, filteredAtts, templatePath, replace);
    }

    private class TNodeInclude
    extends TNode {
        private final String templatePath;
        private final boolean replace;

        public TNodeInclude(SystemInfo info, TextContentParser parser, String qName, Attributes attributes, String templatePath, boolean replace) throws IOException {
            super(info, parser, qName, attributes);
            this.replace = replace;
            this.templatePath = templatePath;
            if (!replace) {
                this.addChild(new TNodeInclude(info, parser, qName, attributes, templatePath, true));
            }
        }

        @Override
        protected Optional<String> canRender(TRenderContext context) {
            return Optional.absent();
        }

        @Override
        public void render(TRenderContext context) throws IOException {
            if (this.replace) {
                Handlers handlers = TransformationContext.getContext().getHandlers();
                FileResult fileResult = handlers.fileResult(this.templatePath, context.getModel(true));
                context.append(fileResult.toString());
            } else {
                super.render(context);
            }
        }
    }
}

