/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.job.config;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class PerPartitionCategorizationConfig
implements ToXContentObject {
    public static final ParseField TYPE_FIELD = new ParseField("per_partition_categorization", new String[0]);
    public static final ParseField ENABLED_FIELD = new ParseField("enabled", new String[0]);
    public static final ParseField STOP_ON_WARN = new ParseField("stop_on_warn", new String[0]);
    public static final ConstructingObjectParser<PerPartitionCategorizationConfig, Void> PARSER = new ConstructingObjectParser(TYPE_FIELD.getPreferredName(), true, a -> new PerPartitionCategorizationConfig((Boolean)a[0], (Boolean)a[1]));
    private final boolean enabled;
    private final boolean stopOnWarn;

    public PerPartitionCategorizationConfig() {
        this(false, null);
    }

    public PerPartitionCategorizationConfig(boolean enabled, Boolean stopOnWarn) {
        this.enabled = enabled;
        this.stopOnWarn = stopOnWarn == null ? false : stopOnWarn;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ENABLED_FIELD.getPreferredName(), this.enabled);
        if (this.enabled) {
            builder.field(STOP_ON_WARN.getPreferredName(), this.stopOnWarn);
        }
        builder.endObject();
        return builder;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isStopOnWarn() {
        return this.stopOnWarn;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PerPartitionCategorizationConfig)) {
            return false;
        }
        PerPartitionCategorizationConfig that = (PerPartitionCategorizationConfig)other;
        return this.enabled == that.enabled && this.stopOnWarn == that.stopOnWarn;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.stopOnWarn);
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), ENABLED_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), STOP_ON_WARN);
    }
}

