/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.util.rmirouting;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RemoteStub;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.server.Unreferenced;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.openrdf.util.rmirouting.ChannelIface;
import org.openrdf.util.rmirouting.ChannelIfaceInvocation;
import org.openrdf.util.rmirouting.Job;
import org.openrdf.util.rmirouting.KeepAliveWhenUnreferenced;
import org.openrdf.util.rmirouting.RoutingAction;

public class ChannelIfaceImpl
implements ChannelIface,
Unreferenced {
    static ThreadLocal currentCookie = new ThreadLocal();
    protected static HashMap map = new HashMap();
    private static Object SYNC_PROLOG = new Object();
    private static RoutingAction aProlog = null;
    private static RoutingAction anEpilog = null;
    private static HashMap primitiveTypes = new HashMap();
    transient Object instance;
    private transient Object _cookie;
    String[] interfaces = null;
    Class[] ifaceClasses = null;

    static Object getCurrentCookie() {
        return currentCookie.get();
    }

    public static void setCurrentCookie(Object cookie) {
        currentCookie.set(cookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void putRef(Remote stub, Object inst) {
        HashMap hashMap = map;
        synchronized (hashMap) {
            map.put(stub, inst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChannelIfaceImpl getRef(Remote stub) {
        HashMap hashMap = map;
        synchronized (hashMap) {
            return (ChannelIfaceImpl)map.get(stub);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPrologAction(RoutingAction newAction) {
        Object object = SYNC_PROLOG;
        synchronized (object) {
            aProlog = newAction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEpilogAction(RoutingAction newAction) {
        Object object = SYNC_PROLOG;
        synchronized (object) {
            aProlog = newAction;
        }
    }

    public static Remote createStub(Object instance) {
        ChannelIfaceImpl result = new ChannelIfaceImpl(instance);
        try {
            RemoteStub stub = UnicastRemoteObject.exportObject(result);
            ChannelIfaceImpl.putRef(stub, result);
            return stub;
        }
        catch (RemoteException e) {
            throw new RuntimeException("error while exporting the stub!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unreferenced() {
        if (this.instance instanceof KeepAliveWhenUnreferenced) {
            return;
        }
        HashMap hashMap = map;
        synchronized (hashMap) {
            Iterator pairs = map.entrySet().iterator();
            while (pairs.hasNext()) {
                Map.Entry e = pairs.next();
                if (!e.getValue().equals(this)) continue;
                try {
                    UnicastRemoteObject.unexportObject(this, true);
                }
                catch (NoSuchObjectException eNSO) {
                    // empty catch block
                }
                pairs.remove();
                break;
            }
        }
    }

    private void buildInterfacesTable() {
        Vector<String> supers = new Vector<String>();
        Vector superClasses = new Vector();
        Class<?> current = this.instance.getClass();
        while (!current.equals(class$java$lang$Object == null ? ChannelIfaceImpl.class$("java.lang.Object") : class$java$lang$Object)) {
            Class<?>[] ifaces = current.getInterfaces();
            for (int i = 0; i < ifaces.length; ++i) {
                Class<?>[] ifP = ifaces[i].getInterfaces();
                if (ifP != null) {
                    for (int j = 0; j < ifP.length; ++j) {
                        if (supers.contains(ifP[j].getName())) continue;
                        supers.add(ifP[j].getName());
                        superClasses.add(ifP[j]);
                    }
                }
                if (supers.contains(ifaces[i].getName())) continue;
                supers.add(ifaces[i].getName());
                superClasses.add(ifaces[i]);
            }
            current = current.getSuperclass();
        }
        this.interfaces = new String[supers.size()];
        this.ifaceClasses = new Class[supers.size()];
        int i3 = 0;
        Iterator i = supers.iterator();
        while (i.hasNext()) {
            this.interfaces[i3] = (String)i.next();
            this.ifaceClasses[i3] = (Class)superClasses.get(i3);
            ++i3;
        }
    }

    protected ChannelIfaceImpl(Object instance) {
        this.instance = instance;
        this.buildInterfacesTable();
        this._cookie = ChannelIfaceImpl.getCurrentCookie();
    }

    public String[] getInterfaces() throws RemoteException {
        return this.interfaces;
    }

    public Object invoke(Object methodDescription, Object[] args) throws RemoteException {
        ChannelIfaceImpl.setCurrentCookie(this._cookie);
        StringTokenizer tokenizer = new StringTokenizer(new String((char[])methodDescription), "|", false);
        Class[] paramTypes = null;
        paramTypes = args != null ? new Class[args.length] : new Class[]{};
        Vector<InvocationHandler> batchedParams = new Vector<InvocationHandler>();
        String methodName = tokenizer.nextToken();
        try {
            InvocationHandler iH;
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                try {
                    paramTypes[i] = Class.forName(token);
                }
                catch (ClassNotFoundException e) {
                    Object oClass = primitiveTypes.get(token);
                    if (oClass == null) {
                        throw e;
                    }
                    paramTypes[i] = (Class)oClass;
                }
                if (args[i] instanceof ChannelIface) {
                    ChannelIfaceImpl tryAsLocal = ChannelIfaceImpl.getRef((Remote)args[i]);
                    if (tryAsLocal != null) {
                        if (tryAsLocal instanceof ChannelIfaceImpl) {
                            args[i] = tryAsLocal.instance;
                        }
                    } else {
                        args[i] = ChannelIfaceInvocation.wrapIt(args[i]);
                        if (args[i] instanceof Proxy) {
                            batchedParams.add(Proxy.getInvocationHandler(args[i]));
                        }
                    }
                }
                ++i;
            }
            if (aProlog != null && this._cookie != null) {
                aProlog.doRoutingAction(this._cookie);
            }
            Method m = null;
            for (int ifaceCount = 0; ifaceCount < this.ifaceClasses.length; ++ifaceCount) {
                try {
                    m = this.ifaceClasses[ifaceCount].getMethod(methodName, paramTypes);
                }
                catch (NoSuchMethodException _nsme) {
                    m = null;
                }
                if (m != null) break;
            }
            if (m == null) {
                m = Object.class.getMethod(methodName, paramTypes);
            }
            Object result = null;
            result = m.invoke(this.instance, args);
            Iterator iter = batchedParams.iterator();
            while (iter.hasNext()) {
                ChannelIfaceInvocation obj = (ChannelIfaceInvocation)iter.next();
                obj.addJob(null);
            }
            batchedParams.clear();
            batchedParams = null;
            if (anEpilog != null && this._cookie != null) {
                anEpilog.doRoutingAction(this._cookie);
            }
            if (!(result == null || result instanceof Remote || result.getClass().isPrimitive() || result instanceof Serializable)) {
                result = ChannelIfaceImpl.createStub(result);
            }
            if (result instanceof Proxy && (iH = Proxy.getInvocationHandler(result)) instanceof ChannelIfaceInvocation) {
                result = ((ChannelIfaceInvocation)iH).remoteInstance;
            }
            return result;
        }
        catch (InvocationTargetException t) {
            throw new RemoteException("While invoking " + methodName, t.getCause());
        }
        catch (Exception t) {
            throw new RemoteException("While invoking " + methodName, t);
        }
    }

    public void gotFinalized() throws RemoteException {
        this.unreferenced();
    }

    public void batch(Object[] jobs) throws RemoteException {
        for (int i = 0; i < jobs.length; ++i) {
            Job job = (Job)jobs[i];
            ByteArrayInputStream buf = new ByteArrayInputStream(job.serializedArgs);
            Object[] args = null;
            try {
                ObjectInputStream inputStream = new ObjectInputStream(buf);
                args = (Object[])inputStream.readObject();
            }
            catch (ClassNotFoundException ec) {
                ec.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.invoke(job.methodDescription, args);
        }
    }

    static {
        primitiveTypes.put(Byte.TYPE.getName(), Byte.TYPE);
        primitiveTypes.put(Character.TYPE.getName(), Character.TYPE);
        primitiveTypes.put(Double.TYPE.getName(), Double.TYPE);
        primitiveTypes.put(Float.TYPE.getName(), Float.TYPE);
        primitiveTypes.put(Integer.TYPE.getName(), Integer.TYPE);
        primitiveTypes.put(Long.TYPE.getName(), Long.TYPE);
        primitiveTypes.put(Short.TYPE.getName(), Short.TYPE);
        primitiveTypes.put(Boolean.TYPE.getName(), Boolean.TYPE);
    }
}

