/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.CharCollection;
import bak.pcj.adapter.CollectionToCharCollectionAdapter;
import bak.pcj.adapter.SetToBooleanSetAdapter;
import bak.pcj.map.AbstractBooleanKeyCharMap;
import bak.pcj.map.BooleanKeyCharMap;
import bak.pcj.map.BooleanKeyCharMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.BooleanSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToBooleanKeyCharMapAdapter
extends AbstractBooleanKeyCharMap
implements BooleanKeyCharMap {
    protected Map map;
    protected Character lastValue;

    public MapToBooleanKeyCharMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToBooleanKeyCharMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(boolean key) {
        this.lastValue = (Character)this.map.get(new Boolean(key));
        return this.lastValue != null;
    }

    public boolean containsValue(char value) {
        return this.map.containsValue(new Character(value));
    }

    public BooleanKeyCharMapIterator entries() {
        return new BooleanKeyCharMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToBooleanKeyCharMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public boolean getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Boolean)this.lastEntry.getKey();
            }

            public char getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return ((Character)this.lastEntry.getValue()).charValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public char get(boolean key) {
        Character value = (Character)this.map.get(new Boolean(key));
        return value == null ? MapDefaults.defaultChar() : value.charValue();
    }

    public BooleanSet keySet() {
        return new SetToBooleanSetAdapter(this.map.keySet());
    }

    public char lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue.charValue();
    }

    public char put(boolean key, char value) {
        Character oldValue = this.map.put(new Boolean(key), new Character(value));
        return oldValue == null ? MapDefaults.defaultChar() : oldValue.charValue();
    }

    public char remove(boolean key) {
        Character value = (Character)this.map.remove(new Boolean(key));
        return value == null ? MapDefaults.defaultChar() : value.charValue();
    }

    public int size() {
        return this.map.size();
    }

    public CharCollection values() {
        return new CollectionToCharCollectionAdapter(this.map.values());
    }

    public char tget(boolean key) {
        Character value = (Character)this.map.get(new Boolean(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value.charValue();
    }

    public boolean validate() {
        return Adapter.isBooleanKeyCharAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

