/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.adapter.ListIteratorToShortListIteratorAdapter;
import bak.pcj.list.AbstractShortList;
import bak.pcj.list.ShortListIterator;
import bak.pcj.util.Exceptions;
import java.util.List;

public class ListToShortListAdapter
extends AbstractShortList {
    protected List list;

    public ListToShortListAdapter(List list) {
        this(list, false);
    }

    public ListToShortListAdapter(List list, boolean validate) {
        if (list == null) {
            Exceptions.nullArgument("list");
        }
        this.list = list;
        if (validate) {
            this.evalidate();
        }
    }

    public void add(int index, short v) {
        this.list.add(index, new Short(v));
    }

    public short get(int index) {
        return (Short)this.list.get(index);
    }

    public ShortListIterator listIterator(int index) {
        return new ListIteratorToShortListIteratorAdapter(this.list.listIterator(index));
    }

    public short removeElementAt(int index) {
        return (Short)this.list.remove(index);
    }

    public short set(int index, short v) {
        return this.list.set(index, new Short(v));
    }

    public int size() {
        return this.list.size();
    }

    public boolean validate() {
        return Adapter.isShortAdaptable(this.list);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("list");
        }
    }
}

