/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj;

import bak.pcj.ByteCollection;
import bak.pcj.ByteIterator;
import bak.pcj.util.Display;
import bak.pcj.util.Exceptions;

public abstract class AbstractByteCollection
implements ByteCollection {
    protected AbstractByteCollection() {
    }

    public boolean add(byte v) {
        Exceptions.unsupported("add");
        return false;
    }

    public boolean addAll(ByteCollection c) {
        ByteIterator i = c.iterator();
        boolean result = false;
        while (i.hasNext()) {
            result |= this.add(i.next());
        }
        return result;
    }

    public void clear() {
        ByteIterator i = this.iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public boolean contains(byte v) {
        ByteIterator i = this.iterator();
        while (i.hasNext()) {
            if (i.next() != v) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(ByteCollection c) {
        ByteIterator i = c.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean remove(byte v) {
        ByteIterator i = this.iterator();
        boolean result = false;
        while (i.hasNext()) {
            if (i.next() != v) continue;
            i.remove();
            result = true;
            break;
        }
        return result;
    }

    public boolean removeAll(ByteCollection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        ByteIterator i = this.iterator();
        boolean result = false;
        while (i.hasNext()) {
            if (!c.contains(i.next())) continue;
            i.remove();
            result = true;
        }
        return result;
    }

    public boolean retainAll(ByteCollection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        ByteIterator i = this.iterator();
        boolean result = false;
        while (i.hasNext()) {
            if (c.contains(i.next())) continue;
            i.remove();
            result = true;
        }
        return result;
    }

    public int size() {
        ByteIterator i = this.iterator();
        int size = 0;
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public byte[] toArray() {
        return this.toArray(null);
    }

    public byte[] toArray(byte[] a) {
        int size = this.size();
        if (a == null || a.length < size) {
            a = new byte[size];
        }
        ByteIterator i = this.iterator();
        int index = 0;
        while (i.hasNext()) {
            a[index] = i.next();
            ++index;
        }
        return a;
    }

    public void trimToSize() {
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        ByteIterator i = this.iterator();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            s.append(Display.display(i.next()));
        }
        s.append(']');
        return s.toString();
    }

    public abstract ByteIterator iterator();
}

