/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import java.io.File;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.fao.geonet.domain.Constants;
import org.fao.geonet.domain.GeonetEntity;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.entitylistener.HarvestHistoryEntityListenerManager;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.hibernate.annotations.Type;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;

@Entity
@Access(value=AccessType.PROPERTY)
@Table(name="HarvestHistory")
@EntityListeners(value={HarvestHistoryEntityListenerManager.class})
@SequenceGenerator(name="harvest_history_id_seq", initialValue=100, allocationSize=1)
public class HarvestHistory
extends GeonetEntity {
    public static final String TABLE_NAME = "HarvestHistory";
    static final String ID_SEQ_NAME = "harvest_history_id_seq";
    public static final String HARVEST_DATE_COLUMN_NAME = "harvestdate";
    public static final String ID_COLUMN_NAME = "id";
    private int _id;
    private ISODate _harvestDate;
    private int _elapsedTime;
    private String _harvesterUuid;
    private String _harvesterName;
    private String _harvesterType;
    private char _deleted = (char)110;
    private String _info;
    private String _params;

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="harvest_history_id_seq")
    @Column(name="id")
    public int getId() {
        return this._id;
    }

    public HarvestHistory setId(int id) {
        this._id = id;
        return this;
    }

    @AttributeOverride(name="dateAndTimeUtc", column=@Column(name="harvestdate", length=30))
    public ISODate getHarvestDate() {
        return this._harvestDate;
    }

    public HarvestHistory setHarvestDate(ISODate harvestDate) {
        this._harvestDate = harvestDate;
        return this;
    }

    @Column(name="elapsedtime")
    public int getElapsedTime() {
        return this._elapsedTime;
    }

    public HarvestHistory setElapsedTime(int elapsedTime) {
        this._elapsedTime = elapsedTime;
        return this;
    }

    @Column(name="harvesteruuid")
    public String getHarvesterUuid() {
        return this._harvesterUuid;
    }

    public HarvestHistory setHarvesterUuid(String harvesterUuid) {
        this._harvesterUuid = harvesterUuid;
        return this;
    }

    @Column(name="harvestername")
    public String getHarvesterName() {
        return this._harvesterName;
    }

    public HarvestHistory setHarvesterName(String harvesterName) {
        this._harvesterName = harvesterName;
        return this;
    }

    @Column(name="harvestertype")
    public String getHarvesterType() {
        return this._harvesterType;
    }

    public HarvestHistory setHarvesterType(String harvesterType) {
        this._harvesterType = harvesterType;
        return this;
    }

    @Column(name="deleted", nullable=false, length=1)
    protected char getDeleted_JpaWorkaround() {
        return this._deleted;
    }

    protected char setDeleted_JpaWorkaround(char deleted) {
        this._deleted = deleted;
        return this._deleted;
    }

    @Transient
    public boolean isDeleted() {
        return Constants.toBoolean_fromYNChar(this.getDeleted_JpaWorkaround());
    }

    public HarvestHistory setDeleted(boolean deleted) {
        this.setDeleted_JpaWorkaround(Constants.toYN_EnabledChar(deleted));
        return this;
    }

    @Lob
    @Type(type="org.hibernate.type.TextType")
    public String getInfo() {
        return this._info;
    }

    @Nonnull
    public HarvestHistory setInfo(@Nullable Element info) {
        if (info == null) {
            this.setInfo((String)null);
        } else {
            this.setInfo(Xml.getString((Element)info));
        }
        return this;
    }

    @Transient
    @Nullable
    public Element getInfoAsXml() throws IOException, JDOMException {
        String info = this.getInfo();
        if (info == null) {
            return null;
        }
        Element infoAsXml = Xml.loadString((String)info, (boolean)false);
        infoAsXml = this.checkInfoXml(infoAsXml);
        return infoAsXml;
    }

    private Element checkInfoXml(Element infoAsXml) {
        List logfileElements = infoAsXml.getChildren("logfile");
        if (logfileElements.size() > 0) {
            if (logfileElements.size() != 1) {
                Log.debug((String)"geonetwork.domain", (Object)("Harvest history unexpectedly lists multiple logfiles: " + logfileElements.size()));
            }
            boolean isLogFileFound = false;
            Iterator iter = logfileElements.iterator();
            while (iter.hasNext()) {
                Element logfile = (Element)iter.next();
                String path = logfile.getText();
                File file = new File(path);
                if (file.exists() && file.canRead()) {
                    if (isLogFileFound) {
                        Log.debug((String)"geonetwork.domain", (Object)("Ignoring add unexpected logfile: `" + path + "`"));
                        iter.remove();
                        continue;
                    }
                    isLogFileFound = true;
                    continue;
                }
                Log.debug((String)"geonetwork.domain", (Object)("Harvest history logfile `" + path + "` ignored, no longer available"));
                iter.remove();
            }
        }
        return infoAsXml;
    }

    protected HarvestHistory setInfo(String info) {
        this._info = info;
        return this;
    }

    @Lob
    @Type(type="org.hibernate.type.TextType")
    public String getParams() {
        return this._params;
    }

    public HarvestHistory setParams(Element params) {
        if (params == null) {
            this.setParams((String)null);
        } else {
            this.setParams(Xml.getString((Element)params));
        }
        return this;
    }

    @Transient
    @Nullable
    public Element getParamsAsXml() throws IOException, JDOMException {
        String params = this.getParams();
        if (params == null) {
            return null;
        }
        return Xml.loadString((String)params, (boolean)false);
    }

    protected HarvestHistory setParams(String params) {
        this._params = params;
        return this;
    }

    @Override
    protected Element asXml(IdentityHashMap<Object, Void> alreadyEncoded) {
        Element element = super.asXml(alreadyEncoded);
        Element infoAsXml = null;
        try {
            infoAsXml = this.getInfoAsXml();
        }
        catch (IOException e) {
            Log.warning((String)"geonetwork.domain", (Object)"error parsing harvest history info element", (Throwable)e);
        }
        catch (JDOMException e) {
            Log.warning((String)"geonetwork.domain", (Object)"error parsing harvest history info element", (Throwable)e);
        }
        Element paramsAsXml = null;
        try {
            paramsAsXml = this.getParamsAsXml();
        }
        catch (IOException e) {
            Log.warning((String)"geonetwork.domain", (Object)"error parsing harvest history params element", (Throwable)e);
        }
        catch (JDOMException e) {
            Log.warning((String)"geonetwork.domain", (Object)"error parsing harvest history params element", (Throwable)e);
        }
        this.replaceWithXml(element, (Content)infoAsXml, "info");
        this.replaceWithXml(element, (Content)paramsAsXml, "params");
        return element;
    }

    private void replaceWithXml(Element element, Content asXml, String tagName) {
        Element info = element.getChild(tagName);
        if (info != null) {
            if (asXml != null) {
                info.removeContent();
                info.addContent(asXml);
            } else {
                info.detach();
            }
        }
    }
}

