/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.csw.common.requests;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.csw.common.ConstraintLanguage;
import org.fao.geonet.csw.common.Csw;
import org.fao.geonet.csw.common.ElementSetName;
import org.fao.geonet.csw.common.ResultType;
import org.fao.geonet.csw.common.TypeName;
import org.fao.geonet.csw.common.requests.CatalogRequest;
import org.fao.geonet.csw.common.util.Xml;
import org.fao.geonet.schema.iso19139.ISO19139Namespaces;
import org.fao.geonet.utils.Log;
import org.jdom.Content;
import org.jdom.Element;

public class GetRecordsRequest
extends CatalogRequest {
    private String outputFormat;
    private Integer startPosition;
    private Integer maxRecords;
    private String constrLangVersion;
    private String constraint;
    private Integer hopCount = 2;
    private boolean distribSearch = false;
    private ResultType resultType;
    private ElementSetName elemSetName;
    private ConstraintLanguage constrLang;
    private Set<TypeName> hsTypeNames = new HashSet<TypeName>();
    private List<String> alSortBy = new ArrayList<String>();

    public GetRecordsRequest(ServiceContext context) {
        super(context);
    }

    public void setResultType(ResultType type) {
        this.resultType = type;
    }

    public void setOutputFormat(String format) {
        this.outputFormat = format;
    }

    public void setStartPosition(Integer start) {
        this.startPosition = start;
    }

    public void setMaxRecords(Integer num) {
        this.maxRecords = num;
    }

    public void setElementSetName(ElementSetName name) {
        this.elemSetName = name;
    }

    public void addTypeName(TypeName typeName) {
        this.hsTypeNames.add(typeName);
    }

    public void setConstraintLanguage(ConstraintLanguage lang) {
        this.constrLang = lang;
    }

    public void setConstraintLangVersion(String version) {
        this.constrLangVersion = version;
    }

    public void setConstraint(String constr) {
        this.constraint = constr;
    }

    public void setHopCount(Integer hopCount) {
        this.hopCount = hopCount;
    }

    public void setDistribSearch(boolean distribSearch) {
        this.distribSearch = distribSearch;
    }

    public void addSortBy(String field) {
        this.alSortBy.add(field);
    }

    @Override
    protected String getRequestName() {
        return "GetRecords";
    }

    @Override
    protected void setupGetParams() {
        this.addParam("request", this.getRequestName());
        this.addParam("service", "CSW");
        this.addParam("version", this.getServerVersion());
        this.addParam("resultType", (Object)this.resultType);
        this.addParam("namespace", "xmlns(" + Csw.NAMESPACE_CSW.getPrefix() + "=" + Csw.NAMESPACE_CSW.getURI() + "),xmlns(" + Csw.NAMESPACE_GMD.getPrefix() + "=" + Csw.NAMESPACE_GMD.getURI() + ")");
        this.addParam("outputFormat", this.outputFormat);
        this.addParam("outputSchema", this.outputSchema);
        this.addParam("startPosition", this.startPosition);
        this.addParam("maxRecords", this.maxRecords);
        this.addParam("elementSetName", (Object)this.elemSetName);
        if (this.constraint != null) {
            this.addParam("constraint", this.constraint);
            this.addParam("constraintLanguage", (Object)this.constrLang);
            this.addParam("constraint_language_version", this.constrLangVersion);
        }
        if (this.distribSearch) {
            this.addParam("distributedSearch", "TRUE");
            if (this.hopCount != null) {
                this.addParam("hopCount", this.hopCount);
            }
        }
        if (this.hsTypeNames.size() == 0) {
            this.addParam("typeNames", "csw:Record");
        } else {
            this.fill("typeNames", this.hsTypeNames);
        }
        this.fill("sortBy", this.alSortBy);
    }

    @Override
    protected Element getPostParams() {
        Element params = new Element(this.getRequestName(), Csw.NAMESPACE_CSW);
        params.addNamespaceDeclaration(Csw.NAMESPACE_DC);
        params.addNamespaceDeclaration(ISO19139Namespaces.GMD);
        this.setAttrib(params, "service", "CSW");
        this.setAttrib(params, "version", this.getServerVersion());
        this.setAttrib(params, "resultType", (Object)this.resultType);
        this.setAttrib(params, "outputFormat", this.outputFormat);
        this.setAttrib(params, "outputSchema", this.outputSchema);
        this.setAttrib(params, "startPosition", this.startPosition);
        this.setAttrib(params, "maxRecords", this.maxRecords);
        if (this.distribSearch) {
            Element ds = new Element("DistributedSearch", Csw.NAMESPACE_CSW);
            ds.setText("TRUE");
            if (this.hopCount != null) {
                ds.setAttribute("hopCount", this.hopCount.toString());
            }
            params.addContent((Content)ds);
        }
        params.addContent((Content)this.getQuery());
        return params;
    }

    private Element getQuery() {
        Element query = new Element("Query", Csw.NAMESPACE_CSW);
        if (this.hsTypeNames.size() == 0) {
            this.setAttrib(query, "typeNames", "csw:Record");
        } else {
            this.setAttribSpaceSeparated(query, "typeNames", this.hsTypeNames, "");
        }
        this.addParam(query, "ElementSetName", (Object)this.elemSetName);
        if (this.constraint != null && this.constrLang != null) {
            Element constr = new Element("Constraint", Csw.NAMESPACE_CSW);
            query.addContent((Content)constr);
            if (this.constrLang == ConstraintLanguage.CQL) {
                this.addParam(constr, "CqlText", (Object)this.constraint);
            } else {
                this.addFilter(constr);
            }
            this.setAttrib(constr, "version", this.constrLangVersion);
        }
        if (this.alSortBy.size() != 0) {
            Element sortBy = new Element("SortBy", Csw.NAMESPACE_OGC);
            query.addContent((Content)sortBy);
            for (String sortInfo : this.alSortBy) {
                String field = sortInfo.substring(0, sortInfo.length() - 2);
                boolean ascen = sortInfo.endsWith(":A");
                Element sortProp = new Element("SortProperty", Csw.NAMESPACE_OGC);
                sortBy.addContent((Content)sortProp);
                Element propName = new Element("PropertyName", Csw.NAMESPACE_OGC).setText(field);
                Element sortOrder = new Element("SortOrder", Csw.NAMESPACE_OGC).setText(ascen ? "ASC" : "DESC");
                sortProp.addContent((Content)propName);
                sortProp.addContent((Content)sortOrder);
            }
        }
        return query;
    }

    private void addFilter(Element constr) {
        try {
            constr.addContent((Content)Xml.loadString(this.constraint, false));
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.csw.search", (Object)("CSW filter error: " + e.getMessage()), (Throwable)e);
        }
    }
}

