/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.csw.common;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.fao.geonet.csw.common.exceptions.InvalidParameterValueEx;

public enum TypeName {
    DATASET("dataset"),
    DATASET_COLLECTION("datasetcollection"),
    SERVICE("service"),
    APPLICATION("application"),
    RECORD("csw:Record"),
    METADATA("gmd:MD_Metadata");

    private String typeName;

    private TypeName(String typeName) {
        this.typeName = typeName;
    }

    public static TypeName getTypeName(String typeName) {
        if (typeName.equals(DATASET.toString())) {
            return DATASET;
        }
        if (typeName.equals(DATASET_COLLECTION.toString())) {
            return DATASET_COLLECTION;
        }
        if (typeName.equals(SERVICE.toString())) {
            return SERVICE;
        }
        if (typeName.equals(APPLICATION.toString())) {
            return APPLICATION;
        }
        if (typeName.equals(RECORD.toString())) {
            return RECORD;
        }
        if (typeName.equals(METADATA.toString())) {
            return METADATA;
        }
        return null;
    }

    public static Set<TypeName> parse(String typeNames) throws InvalidParameterValueEx {
        HashSet<TypeName> hs = new HashSet<TypeName>();
        if (typeNames != null) {
            StringTokenizer st = new StringTokenizer(typeNames, " ");
            while (st.hasMoreTokens()) {
                String typeName = st.nextToken();
                if (typeName.equals(DATASET.toString())) {
                    hs.add(DATASET);
                    continue;
                }
                if (typeName.equals(DATASET_COLLECTION.toString())) {
                    hs.add(DATASET_COLLECTION);
                    continue;
                }
                if (typeName.equals(SERVICE.toString())) {
                    hs.add(SERVICE);
                    continue;
                }
                if (typeName.equals(APPLICATION.toString())) {
                    hs.add(APPLICATION);
                    continue;
                }
                if (typeName.equals(RECORD.toString())) {
                    hs.add(RECORD);
                    continue;
                }
                if (typeName.equals(METADATA.toString())) {
                    hs.add(METADATA);
                    continue;
                }
                if (typeName.equals("csw:BriefRecord")) {
                    throw new InvalidParameterValueEx("typeName", typeName);
                }
                if (!typeName.equals("csw:SummaryRecord")) continue;
                throw new InvalidParameterValueEx("typeName", typeName);
            }
        }
        return hs;
    }

    public String toString() {
        return this.typeName;
    }
}

