/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.geonet;

import org.fao.geonet.exceptions.BadInputEx;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.exceptions.MissingParameterEx;
import org.jdom.Element;

class Group {
    public String name;
    public CopyPolicy policy;

    Group() {
    }

    public Group(Element group) throws BadInputEx {
        this.name = group.getAttributeValue("name");
        if (this.name == null) {
            throw new MissingParameterEx("attribute:name", (Object)group);
        }
        String t = group.getAttributeValue("policy");
        if (t == null) {
            throw new MissingParameterEx("attribute:policy", (Object)group);
        }
        this.policy = CopyPolicy.parse(t);
        if (this.policy == null) {
            throw new BadParameterEx("attribute:policy", (Object)this.policy);
        }
        if (this.policy == CopyPolicy.COPY_TO_INTRANET && !this.isAllGroup()) {
            throw new BadParameterEx("attribute:policy", (Object)this.policy);
        }
        if (this.policy == CopyPolicy.CREATE_AND_COPY && this.isAllGroup()) {
            throw new BadParameterEx("attribute:policy", (Object)this.policy);
        }
    }

    public Group copy() {
        Group m = new Group();
        m.name = this.name;
        m.policy = this.policy;
        return m;
    }

    public boolean isAllGroup() {
        return this.name.equals("all");
    }

    public static enum CopyPolicy {
        COPY("copy"),
        CREATE_AND_COPY("createAndCopy"),
        COPY_TO_INTRANET("copyToIntranet");

        private String policy;

        private CopyPolicy(String policy) {
            this.policy = policy;
        }

        public static CopyPolicy parse(String policy) {
            if (policy.equals(COPY.toString())) {
                return COPY;
            }
            if (policy.equals(CREATE_AND_COPY.toString())) {
                return CREATE_AND_COPY;
            }
            if (policy.equals(COPY_TO_INTRANET.toString())) {
                return COPY_TO_INTRANET;
            }
            return null;
        }

        public String toString() {
            return this.policy;
        }
    }
}

