/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils.nio;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.fao.geonet.utils.IO;

public class PathSourceMixin {
    private final Path path;
    private InputStream inputStream;
    private Reader reader;

    public PathSourceMixin(Path path) {
        this.path = path;
    }

    public InputStream getInputStream() {
        if (this.reader != null) {
            return null;
        }
        if (this.inputStream == null) {
            try {
                this.inputStream = IO.newInputStream(this.path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.inputStream;
    }

    public Reader getReader(Charset charset) {
        if (this.inputStream != null) {
            return null;
        }
        if (this.reader == null) {
            try {
                this.reader = IO.newBufferedReader(this.path, charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.reader;
    }
}

