/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.config.ui;

import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openrdf.sesame.config.SystemConfig;
import org.openrdf.sesame.config.ui.RepositoryTableModel;
import org.openrdf.sesame.config.ui.XCellEditor;
import org.openrdf.sesame.config.ui.XTable;
import org.openrdf.sesame.config.ui.util.Util;

public class RepositoryTable
extends XTable {
    public RepositoryTable(SystemConfig config) {
        super(config);
        this.setXTableModel(new RepositoryTableModel(config));
    }

    protected TableCellRenderer _createCellRenderer(int columnNo) {
        if (columnNo == 0 || columnNo == 1) {
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setHorizontalAlignment(this._model.getColumnAlignment(columnNo));
            return renderer;
        }
        return null;
    }

    protected TableCellEditor _createCellEditor(int columnNo) {
        XCellEditor editor = null;
        if (columnNo == 0) {
            editor = new IdColumnEditor(this);
        } else if (columnNo == 1) {
            editor = new XCellEditor(new JTextField(), (XTable)this);
        }
        return editor;
    }

    public void editingStopped(ChangeEvent e) {
        int row = this.getEditingRow();
        super.editingStopped(e);
        if (this._model.valueIsNew(row, 1)) {
            this.editCellAt(row, 1);
        }
    }

    public void cloneRow() {
        int row = this.getSelectedRow();
        String cloneId = ((RepositoryTableModel)this._model).cloneRow(row);
        int cloneRowIdx = this._model.getRowIndex(cloneId);
        this.editCellAt(cloneRowIdx, 0);
    }

    public void removeRow() {
        String id = this.getIdentifierForSelectedRow();
        if (id == null) {
            this._showWarningDialog("No repository selected.", "Remove Repository");
            return;
        }
        if (Util.showYesNoDialog(this._getOwner(), "Are you sure you want to remove repository '" + id + "'?", "Remove Repository") == 0) {
            int row = this.getSelectedRow();
            this._config.removeRepository(id);
            this.selectPreviousRowTo(row);
        }
    }

    class IdColumnEditor
    extends XCellEditor {
        public IdColumnEditor(RepositoryTable repTable) {
            super(new JTextField(), (XTable)repTable);
        }

        public boolean isValid() {
            String newId = this.getCellEditorValue().toString();
            if (newId.length() == 0) {
                RepositoryTable.this._showWarningDialog("Id required.", "Edit Repository");
                return false;
            }
            String oldId = (String)this._value;
            if (!newId.equals(oldId) && RepositoryTable.this._config.hasRepository(newId)) {
                RepositoryTable.this._showWarningDialog(newId + " already exists.", "Edit Repository");
                return false;
            }
            return true;
        }
    }
}

