/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms.heuristic;

import java.io.IOException;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristicBuilder;

public abstract class NXYSignificanceHeuristic
extends SignificanceHeuristic {
    protected static final ParseField BACKGROUND_IS_SUPERSET = new ParseField("background_is_superset", new String[0]);
    protected static final ParseField INCLUDE_NEGATIVES_FIELD = new ParseField("include_negatives", new String[0]);
    protected static final String SCORE_ERROR_MESSAGE = ", does your background filter not include all documents in the bucket? If so and it is intentional, set \"" + BACKGROUND_IS_SUPERSET.getPreferredName() + "\": false";
    protected final boolean backgroundIsSuperset;
    protected final boolean includeNegatives;

    protected NXYSignificanceHeuristic(boolean includeNegatives, boolean backgroundIsSuperset) {
        this.includeNegatives = includeNegatives;
        this.backgroundIsSuperset = backgroundIsSuperset;
    }

    protected NXYSignificanceHeuristic(StreamInput in) throws IOException {
        this.includeNegatives = in.readBoolean();
        this.backgroundIsSuperset = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.includeNegatives);
        out.writeBoolean(this.backgroundIsSuperset);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NXYSignificanceHeuristic other = (NXYSignificanceHeuristic)obj;
        if (this.backgroundIsSuperset != other.backgroundIsSuperset) {
            return false;
        }
        return this.includeNegatives == other.includeNegatives;
    }

    public int hashCode() {
        int result = this.includeNegatives ? 1 : 0;
        result = 31 * result + (this.backgroundIsSuperset ? 1 : 0);
        return result;
    }

    protected Frequencies computeNxys(long subsetFreq, long subsetSize, long supersetFreq, long supersetSize, String scoreFunctionName) {
        this.checkFrequencies(subsetFreq, subsetSize, supersetFreq, supersetSize, scoreFunctionName);
        Frequencies frequencies = new Frequencies();
        if (this.backgroundIsSuperset) {
            frequencies.N00 = supersetSize - supersetFreq - (subsetSize - subsetFreq);
            frequencies.N01 = subsetSize - subsetFreq;
            frequencies.N10 = supersetFreq - subsetFreq;
            frequencies.N11 = subsetFreq;
            frequencies.N0_ = supersetSize - supersetFreq;
            frequencies.N1_ = supersetFreq;
            frequencies.N_0 = supersetSize - subsetSize;
            frequencies.N_1 = subsetSize;
            frequencies.N = supersetSize;
        } else {
            frequencies.N00 = supersetSize - supersetFreq;
            frequencies.N01 = subsetSize - subsetFreq;
            frequencies.N10 = supersetFreq;
            frequencies.N11 = subsetFreq;
            frequencies.N0_ = supersetSize - supersetFreq + subsetSize - subsetFreq;
            frequencies.N1_ = supersetFreq + subsetFreq;
            frequencies.N_0 = supersetSize;
            frequencies.N_1 = subsetSize;
            frequencies.N = supersetSize + subsetSize;
        }
        return frequencies;
    }

    protected void checkFrequencies(long subsetFreq, long subsetSize, long supersetFreq, long supersetSize, String scoreFunctionName) {
        this.checkFrequencyValidity(subsetFreq, subsetSize, supersetFreq, supersetSize, scoreFunctionName);
        if (this.backgroundIsSuperset) {
            if (subsetFreq > supersetFreq) {
                throw new IllegalArgumentException("subsetFreq > supersetFreq" + SCORE_ERROR_MESSAGE);
            }
            if (subsetSize > supersetSize) {
                throw new IllegalArgumentException("subsetSize > supersetSize" + SCORE_ERROR_MESSAGE);
            }
            if (supersetFreq - subsetFreq > supersetSize - subsetSize) {
                throw new IllegalArgumentException("supersetFreq - subsetFreq > supersetSize - subsetSize" + SCORE_ERROR_MESSAGE);
            }
        }
    }

    protected void build(XContentBuilder builder) throws IOException {
        builder.field(INCLUDE_NEGATIVES_FIELD.getPreferredName(), this.includeNegatives).field(BACKGROUND_IS_SUPERSET.getPreferredName(), this.backgroundIsSuperset);
    }

    protected static void declareParseFields(ConstructingObjectParser<? extends NXYSignificanceHeuristic, ?> parser) {
        parser.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), INCLUDE_NEGATIVES_FIELD);
        parser.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), BACKGROUND_IS_SUPERSET);
    }

    protected static <T> Function<Object[], T> buildFromParsedArgs(BiFunction<Boolean, Boolean, T> ctor) {
        return args -> {
            boolean includeNegatives = args[0] == null ? false : (Boolean)args[0];
            boolean backgroundIsSuperset = args[1] == null ? true : (Boolean)args[1];
            return ctor.apply(includeNegatives, backgroundIsSuperset);
        };
    }

    protected static class Frequencies {
        public double N00;
        public double N01;
        public double N10;
        public double N11;
        public double N0_;
        public double N1_;
        public double N_0;
        public double N_1;
        public double N;

        protected Frequencies() {
        }
    }

    protected static abstract class NXYBuilder
    implements SignificanceHeuristicBuilder {
        protected boolean includeNegatives = true;
        protected boolean backgroundIsSuperset = true;

        public NXYBuilder(boolean includeNegatives, boolean backgroundIsSuperset) {
            this.includeNegatives = includeNegatives;
            this.backgroundIsSuperset = backgroundIsSuperset;
        }

        protected void build(XContentBuilder builder) throws IOException {
            builder.field(INCLUDE_NEGATIVES_FIELD.getPreferredName(), this.includeNegatives).field(BACKGROUND_IS_SUPERSET.getPreferredName(), this.backgroundIsSuperset);
        }
    }
}

