/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.support;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.isdc.wro.model.resource.processor.support.CssColors;

public class Lessify {
    private static final Pattern PATTERN_COLOR = Pattern.compile("#[0-9a-fA-F]{3,6}[^0-9a-fA-F]");
    private static final Pattern PATTERN_WORD_COLOR = Pattern.compile(Lessify.getGiantCssColorRegex());

    public String variablizeColors(String css) {
        LinkedHashSet<String> colors = new LinkedHashSet<String>();
        css = this.conformColors(css);
        Matcher m = PATTERN_COLOR.matcher(css);
        HashMap<String, Integer> colorCount = new HashMap<String, Integer>();
        while (m.find()) {
            String color = m.group().substring(1, m.group().length() - 1);
            colors.add(color);
            if (colorCount.get(color) == null) {
                colorCount.put(color, 1);
                continue;
            }
            colorCount.put(color, (Integer)colorCount.get(color) + 1);
        }
        StringBuffer result = new StringBuffer();
        int idx = 0;
        HashMap<String, String> colorMap = new HashMap<String, String>();
        for (String color : colors) {
            colorMap.put(color, "color" + Lessify.minLeading(idx, 3));
            ++idx;
            result.append("@").append((String)colorMap.get(color)).append(": #").append(this.conformColor(color)).append("; /* used ").append(colorCount.get(color)).append(" times */\n");
        }
        for (String color : colors) {
            css = css.replace("#" + color, "@" + (String)colorMap.get(color));
        }
        result.append(css);
        return result.toString();
    }

    public String conformColors(String css) {
        String color;
        Matcher m = PATTERN_COLOR.matcher(css);
        HashMap<String, String> colGroup = new HashMap<String, String>();
        while (m.find()) {
            color = m.group().substring(1, m.group().length() - 1);
            colGroup.put(m.group(), this.conformColor(color));
        }
        m = PATTERN_WORD_COLOR.matcher(css);
        while (m.find()) {
            color = m.group().substring(1, m.group().length() - 1);
            colGroup.put(m.group(), "#" + this.conformColor(color));
        }
        for (String col : colGroup.keySet()) {
            css = css.replace(col, col.charAt(0) + (String)colGroup.get(col) + col.charAt(col.length() - 1));
        }
        return css;
    }

    private String conformColor(String color) {
        if (CssColors.forName(color) != null) {
            return CssColors.forName(color).getColorAsHexString().toLowerCase();
        }
        if (color.length() == 3) {
            StringBuffer sb = new StringBuffer();
            for (int n = 0; n < color.length(); ++n) {
                sb.append(color.charAt(n));
                sb.append(color.charAt(n));
            }
            return sb.toString().toLowerCase();
        }
        return Lessify.minLeading(color, 6).toLowerCase();
    }

    private static String minLeading(int val, int min) {
        return Lessify.minLeading(Integer.toString(val), min);
    }

    private static String minLeading(String val, int min) {
        StringBuffer result = new StringBuffer(val);
        while (result.length() < min) {
            result.insert(0, "0");
        }
        return result.toString();
    }

    private static String getGiantCssColorRegex() {
        StringBuffer sb = new StringBuffer("");
        boolean first = true;
        for (CssColors col : CssColors.values()) {
            if (!first) {
                sb.append("|");
            }
            sb.append("(").append(Lessify.buildRegexForCssColor(col)).append(")");
            first = false;
        }
        return sb.toString();
    }

    private static String buildRegexForCssColor(CssColors col) {
        StringBuffer sb = new StringBuffer("[\\s\\n\\r\\:]");
        for (int n = 0; n < col.name().length(); ++n) {
            sb.append("[").append(Character.toLowerCase(col.name().charAt(n))).append(Character.toUpperCase(col.name().charAt(n))).append("]");
        }
        sb.append("[\\s\\n\\r;]");
        return sb.toString();
    }
}

