/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.util.z3950.jzkitextensions;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jzkit.ServiceDirectory.AttributeSetDBO;
import org.jzkit.configuration.api.Configuration;
import org.jzkit.configuration.api.ConfigurationException;
import org.jzkit.search.util.Profile.AttrMappingDBO;
import org.jzkit.search.util.Profile.CrosswalkDBO;
import org.jzkit.search.util.Profile.ProfileDBO;
import org.jzkit.search.util.Profile.ProfileService;
import org.jzkit.search.util.Profile.ProfileServiceException;
import org.jzkit.search.util.Profile.QueryVerifyResult;
import org.jzkit.search.util.QueryModel.Internal.AttrPlusTermNode;
import org.jzkit.search.util.QueryModel.Internal.AttrValue;
import org.jzkit.search.util.QueryModel.Internal.ComplexNode;
import org.jzkit.search.util.QueryModel.Internal.InternalModelNamespaceNode;
import org.jzkit.search.util.QueryModel.Internal.InternalModelRootNode;
import org.jzkit.search.util.QueryModel.Internal.QueryNode;
import org.jzkit.search.util.QueryModel.InvalidQueryException;
import org.jzkit.search.util.QueryModel.QueryModel;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class GNProfileService
implements ProfileService,
ApplicationContextAware {
    public static final int ERROR_QUERY = 1;
    public static final int ERROR_CONFIG = 2;
    private static Log log = LogFactory.getLog(GNProfileService.class);
    private ApplicationContext ctx = null;
    private Configuration configuration = null;

    public void setApplicationContext(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public InternalModelRootNode makeConformant(QueryModel qm, Map<String, AttributeSetDBO> valid_attributes, Map<String, AttrValue> service_specific_rewrite_rules, String profile_code) throws ProfileServiceException {
        InternalModelRootNode result = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("makeConformant profile:" + profile_code + " query:" + qm.toString()));
        }
        try {
            ProfileDBO p = this.configuration.lookupProfile(profile_code);
            if (p == null && valid_attributes == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No profile defined and no valid attributes list, unable to rewrite");
                }
                result = qm.toInternalQueryModel(this.ctx);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Rewriting");
                }
                result = (InternalModelRootNode)this.visit((QueryNode)qm.toInternalQueryModel(this.ctx), "bib-1", valid_attributes, service_specific_rewrite_rules, p);
            }
        }
        catch (InvalidQueryException iqe) {
            throw new ProfileServiceException(iqe.toString(), 1);
        }
        catch (ConfigurationException ce) {
            throw new ProfileServiceException(ce.toString(), 2);
        }
        return result;
    }

    private QueryNode visit(QueryNode qn, String default_namespace, Map<String, AttributeSetDBO> valid_attributes, Map<String, AttrValue> service_specific_rewrite_rules, ProfileDBO p) throws InvalidQueryException, ProfileServiceException {
        if (qn == null) {
            throw new InvalidQueryException("Query node was null, unable to rewrite");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Rewrite: visit instance of " + qn.getClass().getName()));
        }
        if (qn instanceof InternalModelRootNode) {
            InternalModelRootNode imrn = (InternalModelRootNode)qn;
            return new InternalModelRootNode(this.visit(imrn.getChild(), default_namespace, valid_attributes, service_specific_rewrite_rules, p));
        }
        if (qn instanceof InternalModelNamespaceNode) {
            InternalModelNamespaceNode imns = (InternalModelNamespaceNode)qn;
            if (log.isDebugEnabled()) {
                log.debug((Object)("child default attrset will be " + imns.getAttrset()));
            }
            return new InternalModelNamespaceNode(imns.getAttrset(), this.visit(imns.getChild(), imns.getAttrset(), valid_attributes, service_specific_rewrite_rules, p));
        }
        if (qn instanceof ComplexNode) {
            ComplexNode cn = (ComplexNode)qn;
            QueryNode lhs = null;
            QueryNode rhs = null;
            if (cn.getLHS() != null && cn.getLHS().countChildrenWithTerms() > 0) {
                lhs = this.visit(cn.getLHS(), default_namespace, valid_attributes, service_specific_rewrite_rules, p);
            }
            if (cn.getRHS() != null && cn.getRHS().countChildrenWithTerms() > 0) {
                rhs = this.visit(cn.getRHS(), default_namespace, valid_attributes, service_specific_rewrite_rules, p);
            }
            if (lhs != null && rhs != null) {
                return new ComplexNode(lhs, rhs, cn.getOp());
            }
            if (lhs != null) {
                return lhs;
            }
            return rhs;
        }
        if (qn instanceof AttrPlusTermNode) {
            AttrPlusTermNode aptn = null;
            aptn = valid_attributes != null && service_specific_rewrite_rules != null && valid_attributes.size() > 0 ? this.rewriteUntilValid((AttrPlusTermNode)qn, valid_attributes, service_specific_rewrite_rules, default_namespace) : this.rewriteUntilValid((AttrPlusTermNode)qn, p, default_namespace);
            if (aptn == null) {
                throw new ProfileServiceException("Unable to rewrite node. Semantic action was set to strict, and there appears to be no valid alternatives for node " + qn, 1);
            }
            return aptn;
        }
        throw new ProfileServiceException("Should never be here");
    }

    private AttrPlusTermNode rewriteUntilValid(AttrPlusTermNode q, Map<String, AttributeSetDBO> valid_attributes, Map<String, AttrValue> service_specific_rewrite_rules, String default_namespace) throws InvalidQueryException, ProfileServiceException {
        Iterator attrIterator;
        AttrPlusTermNode result = q;
        Iterator i = attrIterator = q.getAttrIterator();
        while (i.hasNext()) {
            AttributeSetDBO as;
            String attr_type = (String)i.next();
            AttrValue av = (AttrValue)q.getAttr(attr_type);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Rewriting " + attr_type + "=" + av));
            }
            if ((as = valid_attributes.get(attr_type)) == null) {
                throw new ProfileServiceException("No " + attr_type + " attr types allowed for target repository", 4);
            }
            AttrValue new_av = this.rewriteUntilValid(av, as.getAttrs(), service_specific_rewrite_rules, default_namespace);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting attr " + attr_type + " to " + new_av));
            }
            q.setAttr(attr_type, (Object)new_av);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)q.getAttrs());
        }
        return result;
    }

    private AttrValue rewriteUntilValid(AttrValue av, Set<AttrValue> explain_use_indexes, Map<String, AttrValue> service_specific_rewrite_rules, String default_namespace) throws ProfileServiceException {
        AttrValue result = av;
        if (av != null) {
            String av_str_val = av.getWithDefaultNamespace(default_namespace);
            if (explain_use_indexes.contains(av)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No need to rewrite, source index " + av + " is already allowed by target"));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Rewrite, source index " + av + " is disallowed, scanning server alternatives allowed=" + explain_use_indexes));
                }
                boolean found = false;
                Set<Map.Entry<String, AttrValue>> entrySet = service_specific_rewrite_rules.entrySet();
                Iterator<Map.Entry<String, AttrValue>> i = entrySet.iterator();
                while (i.hasNext() && !found) {
                    Map.Entry<String, AttrValue> e = i.next();
                    if (!e.getKey().equals(av_str_val)) continue;
                    AttrValue new_av = e.getValue();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Possible rewrite: " + new_av));
                    }
                    if (!explain_use_indexes.contains(new_av)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Matched, replacing");
                    }
                    result = new_av;
                    found = true;
                }
                if (!found) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Unable to rewrite query, exception");
                    }
                    throw new ProfileServiceException("Unable to rewrite access point '" + av_str_val + "' to comply with service explain record", 1);
                }
            }
        }
        return result;
    }

    private AttrPlusTermNode rewriteUntilValid(AttrPlusTermNode q, ProfileDBO p, String default_namespace) throws ProfileServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("rewriteUntilValid.... def ns = " + default_namespace));
        }
        QueryVerifyResult qvr = p.validate(q, default_namespace);
        AttrPlusTermNode result = null;
        if (qvr.queryIsValid()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Node is conformant to profile.... return it");
            }
            result = q;
        } else {
            String failing_attr_type;
            AttrValue av;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Node does not conform to profile (" + q.getAccessPoint() + " not allowed by profile " + p.getCode() + ")"));
            }
            if ((av = (AttrValue)q.getAttr(failing_attr_type = qvr.getFailingAttr())) != null) {
                Set<AttrValue> possible_alternatives = this.lookupKnownAlternatives(av, default_namespace);
                if (possible_alternatives != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Check out alternatives for " + failing_attr_type + ":" + possible_alternatives));
                    }
                    Iterator<AttrValue> i = possible_alternatives.iterator();
                    while (i.hasNext() && result == null) {
                        AttrValue target_av = i.next();
                        AttrPlusTermNode new_variant = q.cloneForAttrs();
                        new_variant.setAttr(failing_attr_type, (Object)target_av);
                        result = this.rewriteUntilValid(new_variant, p, default_namespace);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)"No expansions available. Return null");
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Hmm.. It appears that we failed because a rule required an attr type which is not present in the query tree(" + failing_attr_type + "). Perhaps we should add missing attrs ;)"));
            }
        }
        return result;
    }

    private Set<AttrValue> lookupKnownAlternatives(AttrValue av, String default_namespace) {
        Set result = null;
        try {
            CrosswalkDBO cw;
            String namespace = av.getNamespaceIdentifier();
            if (namespace == null) {
                namespace = default_namespace;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Lookup mappings from namespace " + namespace + " attr value = " + av.getValue()));
            }
            if ((cw = this.configuration.lookupCrosswalk(namespace)) != null) {
                AttrMappingDBO am = cw.lookupMapping((Object)av.getValue().toString());
                if (am != null) {
                    result = am.getTargetAttrs();
                }
            } else {
                log.warn((Object)("No crosswalk available for source namespace " + namespace));
            }
        }
        catch (ConfigurationException ce) {
            log.warn((Object)("Problem looking up alternatives for " + av.getValue().toString()), (Throwable)ce);
        }
        return result;
    }
}

