/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.resources;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletContext;
import jeeves.server.context.ServiceContext;
import org.apache.commons.io.FilenameUtils;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.resources.Resources;
import org.fao.geonet.resources.S3Credentials;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class S3Resources
extends Resources {
    @Autowired
    S3Credentials s3;

    @Override
    protected Path getBasePath(ServiceContext context) {
        return Paths.get("/", new String[0]);
    }

    @Override
    public Path locateResourcesDir(ServletContext context, ApplicationContext applicationContext) {
        return Paths.get("/resources", new String[0]);
    }

    @Override
    protected Path locateResourcesDir(ServiceContext context) {
        return Paths.get("/resources", new String[0]);
    }

    private String getKey(Path dir, String name) {
        return this.getKey(dir.resolve(name));
    }

    private String getKey(Path path) {
        String pathString = path.getFileSystem().getSeparator().equals("/") ? path.toString() : path.toString().replace(path.getFileSystem().getSeparator(), "/");
        return this.s3.getKeyPrefix() + (path.isAbsolute() ? pathString.substring(2) : pathString.substring(1));
    }

    private Path getKeyPath(String key) {
        return Paths.get("/" + key.substring(this.s3.getKeyPrefix().length()), new String[0]);
    }

    @Override
    @Nullable
    protected Path findImagePath(String imageName, Path logosDir) {
        String key = this.getKey(logosDir, imageName);
        if (imageName.indexOf(46) > -1) {
            if (this.s3.getClient().doesObjectExist(this.s3.getBucket(), key)) {
                return this.getKeyPath(key);
            }
        } else {
            ListObjectsV2Result objects = this.s3.getClient().listObjectsV2(this.s3.getBucket(), key);
            for (S3ObjectSummary next : objects.getObjectSummaries()) {
                String ext = FilenameUtils.getExtension((String)next.getKey());
                if (!IMAGE_EXTENSIONS.contains(ext.toLowerCase())) continue;
                return this.getKeyPath(next.getKey());
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Resources.ResourceHolder getImage(ServiceContext context, String imageName, Path logosDir) {
        Path path = this.findImagePath(imageName, logosDir);
        if (path != null) {
            String key = this.getKey(path);
            return new S3ResourceHolder(key, false);
        }
        return null;
    }

    @Override
    public Resources.ResourceHolder getWritableImage(ServiceContext context, String imageName, Path logosDir) {
        return new S3ResourceHolder(this.getKey(logosDir, imageName), true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    Pair<byte[], Long> loadResource(Path resourcesDir, ServletContext context, Path appPath, String filename, byte[] defaultValue, long loadSince) throws IOException {
        Path file = this.locateResource(resourcesDir, context, appPath, filename);
        String key = this.getKey(file);
        try {
            S3Object object = this.s3.getClient().getObject(this.s3.getBucket(), key);
            long lastModified = object.getObjectMetadata().getLastModified().toInstant().toEpochMilli();
            try (S3ObjectInputStream in = object.getObjectContent();){
                if (loadSince < 0L || lastModified > loadSince) {
                    byte[] content = new byte[(int)object.getObjectMetadata().getContentLength()];
                    new DataInputStream((InputStream)in).readFully(content);
                    Pair pair2 = Pair.read((Object)content, (Object)lastModified);
                    return pair2;
                }
                Pair pair = Pair.read((Object)defaultValue, (Object)loadSince);
                return pair;
            }
        }
        catch (AmazonS3Exception e) {
            if (e.getStatusCode() == 404) return Pair.read((Object)defaultValue, (Object)-1L);
            throw e;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected Path locateResource(@Nullable Path resourcesDir, ServletContext context, Path appPath, @Nonnull String filename) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void addFiles(DirectoryStream.Filter<Path> iconFilter, Path webappDir, HashSet<Path> result) {
        ListObjectsV2Result objects = this.s3.getClient().listObjectsV2(this.s3.getBucket(), this.getKey(webappDir) + "/");
        for (S3ObjectSummary cur : objects.getObjectSummaries()) {
            Path curPath = this.getKeyPath(cur.getKey());
            try {
                if (!iconFilter.accept(curPath)) continue;
                result.add(curPath);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    @Nullable
    public FileTime getLastModified(Path resourcesDir, ServletContext context, Path appPath, String filename) throws IOException {
        Path file = this.locateResource(resourcesDir, context, appPath, filename);
        String key = this.getKey(file);
        try {
            ObjectMetadata md = this.s3.getClient().getObjectMetadata(this.s3.getBucket(), key);
            return FileTime.from(md.getLastModified().toInstant());
        }
        catch (AmazonS3Exception e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public void deleteImageIfExists(String image, Path dir) {
        Path icon = this.findImagePath(image, dir);
        if (icon != null) {
            this.s3.getClient().deleteObject(this.s3.getBucket(), this.getKey(icon));
        }
    }

    private class S3ResourceHolder
    implements Resources.ResourceHolder {
        private final String key;
        private Path path = null;
        private boolean writeOnClose = false;

        private S3ResourceHolder(String key, boolean writeOnClose) {
            this.key = key;
            this.writeOnClose = writeOnClose;
        }

        @Override
        public Path getPath() {
            if (this.path != null) {
                return this.path;
            }
            String[] splittedKey = this.key.split("/");
            try {
                this.path = Files.createTempFile("", splittedKey[splittedKey.length - 1], new FileAttribute[0]);
                try {
                    S3Object object = S3Resources.this.s3.getClient().getObject(S3Resources.this.s3.getBucket(), this.key);
                    try (S3ObjectInputStream in = object.getObjectContent();){
                        Files.copy((InputStream)in, this.path, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (AmazonServiceException e) {
                    if (e.getStatusCode() == 404 && this.writeOnClose) {
                        Files.delete(this.path);
                    } else if (e.getStatusCode() != 404) {
                        throw e;
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.path;
        }

        @Override
        public String getRelativePath() {
            return this.key;
        }

        @Override
        public FileTime getLastModifiedTime() {
            ObjectMetadata md = S3Resources.this.s3.getClient().getObjectMetadata(S3Resources.this.s3.getBucket(), this.key);
            return FileTime.from(md.getLastModified().toInstant());
        }

        @Override
        public void abort() {
            this.writeOnClose = false;
        }

        @Override
        public void close() throws IOException {
            if (this.path == null) {
                return;
            }
            if (this.writeOnClose && Files.isReadable(this.path)) {
                S3Resources.this.s3.getClient().putObject(S3Resources.this.s3.getBucket(), this.key, this.path.toFile());
            }
            Files.delete(this.path);
        }
    }
}

