/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.keycloak;

import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.kernel.security.SecurityProviderConfiguration;
import org.fao.geonet.kernel.security.keycloak.KeycloakConfiguration;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.KeycloakDeployment;

public final class KeycloakXslUtil {
    private static KeycloakConfiguration keycloakConfiguration = null;
    private static KeycloakDeployment keycloakDeployment = null;

    private static void loadSecurityProviderConfiguration() {
        if (keycloakConfiguration == null) {
            keycloakConfiguration = (KeycloakConfiguration)ApplicationContextHolder.get().getBean(KeycloakConfiguration.class);
        }
        if (keycloakConfiguration == null) {
            throw new RuntimeException("Keycloak security provider configuration is not found");
        }
        if (keycloakDeployment == null) {
            keycloakDeployment = ((AdapterDeploymentContext)ApplicationContextHolder.get().getBean(AdapterDeploymentContext.class)).resolveDeployment(null);
        }
        if (keycloakDeployment == null) {
            throw new RuntimeException("Cannot locate keycloak resolver to read the keycloak.json file");
        }
    }

    public static String getRealm() {
        KeycloakXslUtil.loadSecurityProviderConfiguration();
        return keycloakDeployment.getRealm();
    }

    public static String getAuthServerBaseUrl() {
        KeycloakXslUtil.loadSecurityProviderConfiguration();
        return keycloakDeployment.getAuthServerBaseUrl();
    }

    public static String getClientId() {
        KeycloakXslUtil.loadSecurityProviderConfiguration();
        if (keycloakDeployment.isPublicClient()) {
            return keycloakDeployment.getResourceName();
        }
        return keycloakConfiguration.getPublicClientId();
    }

    public static String getInitOnLoad() {
        KeycloakXslUtil.loadSecurityProviderConfiguration();
        if (keycloakConfiguration.getLoginType().equals(SecurityProviderConfiguration.LoginType.AUTOLOGIN.toString().toLowerCase())) {
            return "login-required";
        }
        return "check-sso";
    }
}

