/*
 * Decompiled with CFR 0.152.
 */
package jeeves.config.springutil;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.fao.geonet.ApplicationContextHolder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.filter.DelegatingFilterProxy;
import org.springframework.web.filter.GenericFilterBean;

public class JeevesDelegatingFilterProxy
extends GenericFilterBean {
    private static final InheritableThreadLocal<String> applicationContextAttributeKey = new InheritableThreadLocal();
    String trustedHost;
    private HashMap<String, Filter> _nodeIdToFilterMap = new HashMap();

    public static ServletContext getServletContext(ServletContext fallback) {
        if (ApplicationContextHolder.get() != null) {
            return (ServletContext)ApplicationContextHolder.get().getBean(ServletContext.class);
        }
        return fallback;
    }

    public static ConfigurableApplicationContext getApplicationContextFromServletContext(ServletContext servletContext) {
        Object applicationContext = servletContext.getAttribute((String)applicationContextAttributeKey.get());
        return (ConfigurableApplicationContext)applicationContext;
    }

    @VisibleForTesting
    public static void setApplicationContextAttributeKey(String key) {
        applicationContextAttributeKey.set(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            if (request instanceof HttpServletRequest) {
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                String servletPath = httpRequest.getServletPath();
                if (servletPath.isEmpty()) {
                    servletPath = "/jeevesNodeApplicationContext_";
                }
                String nodeName = servletPath.substring(1);
                String nodeId = "jeevesNodeApplicationContext_" + nodeName;
                if (this.getServletContext().getAttribute(nodeId) == null) {
                    nodeId = "jeevesNodeApplicationContext_" + request.getParameter("node");
                    if (this.getServletContext().getAttribute(nodeId) == null) {
                        nodeId = this.loadNodeIdFromReferrer(request, httpRequest, nodeId);
                    }
                    if (nodeId == null || this.getServletContext().getAttribute(nodeId) == null) {
                        nodeId = "jeevesNodeApplicationContext_";
                    }
                }
                applicationContextAttributeKey.set(nodeId);
                ConfigurableApplicationContext applicationContext = JeevesDelegatingFilterProxy.getApplicationContextFromServletContext(this.getServletContext());
                ApplicationContextHolder.set((ConfigurableApplicationContext)applicationContext);
                this.getDelegateFilter(nodeId, (WebApplicationContext)applicationContext).doFilter(request, response, filterChain);
            } else {
                response.getWriter().write(request.getClass().getName() + " is not a supported type of request");
            }
        }
        finally {
            ApplicationContextHolder.clear();
        }
    }

    private String loadNodeIdFromReferrer(ServletRequest request, HttpServletRequest httpRequest, String nodeId) {
        String referer = httpRequest.getHeader("referer");
        if (this.urlIfFromThisServer(request, referer)) {
            nodeId = "jeevesNodeApplicationContext_" + this.extractNodeIdFromUrl(referer);
        }
        return nodeId;
    }

    public String getTrustedHost() {
        return this.trustedHost;
    }

    public void setTrustedHost(String trustedHost) {
        this.trustedHost = trustedHost;
    }

    private String extractNodeIdFromUrl(String referer) {
        String[] split = referer.split(this.getServletContext().getContextPath() + "/", 2);
        if (split.length == 1) {
            return null;
        }
        int nextSlash = split[1].indexOf(47, 1);
        if (nextSlash > -1) {
            return split[1].substring(0, nextSlash);
        }
        return null;
    }

    private boolean urlIfFromThisServer(ServletRequest request, String referer) {
        if (referer == null) {
            return false;
        }
        try {
            URL refererUrl = new URL(referer);
            HashSet<InetAddress> refererInetAddress = new HashSet<InetAddress>(Arrays.asList(InetAddress.getAllByName(refererUrl.getHost())));
            for (String trusted : this.getTrustedHost().split(",")) {
                InetAddress[] localINetAddres;
                for (InetAddress localAddress : localINetAddres = InetAddress.getAllByName(trusted.trim())) {
                    if (!refererInetAddress.contains(localAddress)) continue;
                    return true;
                }
            }
        }
        catch (UnknownHostException e) {
            return false;
        }
        catch (MalformedURLException e) {
            return false;
        }
        return false;
    }

    private synchronized Filter getDelegateFilter(String nodeId, WebApplicationContext context) {
        Filter filter = this._nodeIdToFilterMap.get(nodeId);
        if (filter == null) {
            filter = new DelegatingFilterProxy(this.getFilterName(), context);
            this._nodeIdToFilterMap.put(nodeId, filter);
        }
        return filter;
    }
}

