/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.dav.DAVBaselineInfo;
import org.tmatesoft.svn.core.internal.io.dav.DAVConnection;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.DAVUtil;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.util.SVNLogType;

class DAVResource {
    private String myWURL;
    private String myVURL;
    private String myURL;
    private String myPath;
    private ISVNWorkspaceMediator myMediator;
    private long myRevision;
    private boolean myIsCopy;
    private DAVConnection myConnection;
    private SVNProperties myProperties;
    private boolean myIsAdded;

    public DAVResource(ISVNWorkspaceMediator mediator, DAVConnection connection, String path, long revision) {
        this(mediator, connection, path, revision, false);
    }

    public DAVResource(ISVNWorkspaceMediator mediator, DAVConnection connection, String path, long revision, boolean isCopy) {
        this.myPath = path;
        this.myMediator = mediator;
        String locationPath = SVNEncodingUtil.uriEncode(connection.getLocation().getPath());
        this.myURL = SVNPathUtil.append(locationPath, path);
        this.myRevision = revision;
        this.myConnection = connection;
        this.myIsCopy = isCopy;
    }

    public void setAdded(boolean added) {
        this.myIsAdded = added;
    }

    public boolean isAdded() {
        return this.myIsAdded;
    }

    public boolean isCopy() {
        return this.myIsCopy;
    }

    public String getURL() {
        return this.myURL;
    }

    public String getPath() {
        return this.myPath;
    }

    public String getVersionURL() {
        return this.myVURL;
    }

    public void fetchVersionURL(DAVResource parent, boolean force) throws SVNException {
        if (!force && this.getVersionURL() != null) {
            return;
        }
        if (!force) {
            if (this.myMediator != null && DAVUtil.isUseDAVWCURL()) {
                SVNPropertyValue value = this.myMediator.getWorkspaceProperty(SVNEncodingUtil.uriDecode(this.myPath), "svn:wc:ra_dav:version-url");
                String string = this.myVURL = value == null ? null : value.getString();
                if ("".equals(this.myVURL)) {
                    this.myMediator.setWorkspaceProperty(SVNEncodingUtil.uriDecode(this.myPath), "svn:wc:ra_dav:version-url", null);
                    this.myVURL = null;
                }
                if (this.myVURL != null) {
                    return;
                }
            }
            if (parent != null && parent.getVersionURL() != null && parent.myRevision == this.myRevision) {
                this.myVURL = SVNPathUtil.append(parent.getVersionURL(), SVNPathUtil.tail(this.myPath));
                return;
            }
        }
        String path = this.myURL;
        if (this.myRevision >= 0L) {
            DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, null, path, this.myRevision, false, false, null);
            path = SVNPathUtil.append(info.baselineBase, info.baselinePath);
        }
        try {
            this.myVURL = DAVUtil.getPropertyValue(this.myConnection, path, null, DAVElement.CHECKED_IN);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_DAV_PROPS_NOT_FOUND) {
                SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.PROPERTY_NOT_FOUND, "Could not fetch the Version Resource URL (needed during an import or when it is missing from the local, cached props)");
                SVNErrorManager.error(error, e, SVNLogType.NETWORK);
            }
            throw e;
        }
        if (this.myMediator != null) {
            SVNPropertyValue urlPropertyValue = DAVUtil.isUseDAVWCURL() ? SVNPropertyValue.create(this.myVURL) : null;
            this.myMediator.setWorkspaceProperty(SVNEncodingUtil.uriDecode(this.myPath), "svn:wc:ra_dav:version-url", urlPropertyValue);
        }
    }

    public String getWorkingURL() {
        return this.myWURL;
    }

    public void dispose() {
        this.myProperties = null;
    }

    public void setWorkingURL(String location) {
        this.myWURL = location;
    }

    public void putProperty(String name, String value) {
        if (this.myProperties == null) {
            this.myProperties = new SVNProperties();
        }
        this.myProperties.put(name, value);
    }

    public void putProperty(String name, SVNPropertyValue value) {
        if (this.myProperties == null) {
            this.myProperties = new SVNProperties();
        }
        this.myProperties.put(name, value);
    }

    public SVNProperties getProperties() {
        return this.myProperties;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(this.myURL);
        sb.append("][");
        sb.append(this.myVURL);
        sb.append("][");
        sb.append(this.myWURL);
        sb.append("][");
        sb.append(this.myPath);
        sb.append("]");
        return sb.toString();
    }
}

