/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.util;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class ImageUtil {
    public static Dimension getScaledDimension(Dimension imgSize, Dimension boundary) {
        int original_width = imgSize.width;
        int original_height = imgSize.height;
        int bound_width = boundary.width;
        int bound_height = boundary.height;
        int new_width = original_width;
        int new_height = original_height;
        if (original_width > bound_width) {
            new_width = bound_width;
            new_height = new_width * original_height / original_width;
        }
        if (new_height > bound_height) {
            new_height = bound_height;
            new_width = new_height * original_width / original_height;
        }
        return new Dimension(new_width, new_height);
    }

    public static BufferedImage resize(BufferedImage img, int size) {
        Dimension imgSize = new Dimension(img.getWidth(), img.getHeight());
        Dimension boundary = new Dimension(size, size);
        Dimension scaledDimension = ImageUtil.getScaledDimension(imgSize, boundary);
        int width = (int)scaledDimension.getWidth();
        int height = (int)scaledDimension.getHeight();
        Image tmp = img.getScaledInstance(width, height, 4);
        BufferedImage resized = new BufferedImage(width, height, 2);
        Graphics2D g2d = resized.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return resized;
    }
}

