/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.util.z3950.transformers;

import java.net.URI;
import java.nio.file.Path;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.fao.geonet.ContextContainer;
import org.fao.geonet.guiservices.schemas.GetSchemaInfo;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.DOMBuilder;
import org.jzkit.search.util.RecordConversion.FragmentTransformationException;
import org.jzkit.search.util.RecordConversion.FragmentTransformer;
import org.springframework.context.ApplicationContext;

public class GNTransformer
extends FragmentTransformer {
    private Path stylesheetPath;
    private DocumentBuilder htmldb = null;

    public GNTransformer(String from, String to, Map properties, Map context, ApplicationContext ctx) {
        super(from, to, properties, context, ctx);
        this.ctx = ctx;
        String stylesheet = (String)properties.get("Sheet");
        if (stylesheet == null) {
            Log.error((String)"geonetwork.search", (Object)("Failed to get name of stylesheet from properties - looking for property with name 'Sheet' - found instead: " + properties));
            return;
        }
        try {
            this.stylesheetPath = IO.toPath((URI)ctx.getResource(stylesheet).getURI());
            if (Log.isDebugEnabled((String)"geonetwork.search")) {
                Log.debug((String)"geonetwork.search", (Object)("Stylesheet for " + from + " to " + to + " is " + stylesheet));
            }
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.search", (Object)("Problem with stylesheet: " + stylesheet), (Throwable)e);
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            dbf.setNamespaceAware(true);
            dbf.setIgnoringComments(false);
            dbf.setIgnoringElementContentWhitespace(false);
            dbf.setExpandEntityReferences(false);
            this.htmldb = dbf.newDocumentBuilder();
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.search", (Object)e.getMessage(), (Throwable)e);
        }
    }

    public org.w3c.dom.Document transform(org.w3c.dom.Document input, Map additional_properties) throws FragmentTransformationException {
        DOMBuilder builder = new DOMBuilder();
        Document jdomDoc = builder.build(input);
        ContextContainer cnt = (ContextContainer)this.ctx.getBean("ContextGateway");
        Element elem = null;
        try {
            Element root = new Element("root");
            Element gui = new Element("gui");
            GetSchemaInfo gsi = new GetSchemaInfo();
            gui.addContent((Content)gsi.exec(new Element("request"), cnt.getSrvctx()));
            root.addContent((Content)gui);
            Element metadata = new Element("metadata");
            metadata.addContent((Content)jdomDoc.detachRootElement());
            root.addContent((Content)metadata);
            elem = Xml.transform((Element)root, (Path)this.stylesheetPath);
        }
        catch (Exception e) {
            throw new FragmentTransformationException(e.getMessage());
        }
        org.w3c.dom.Document output = null;
        try {
            output = this.htmldb.newDocument();
            org.w3c.dom.Element root = output.createElement("HTML");
            root.appendChild(output.createTextNode(Xml.getString((Element)elem)));
            output.appendChild(root);
        }
        catch (Exception e) {
            throw new FragmentTransformationException(e.getMessage());
        }
        return output;
    }
}

