/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.rdf;

import com.google.common.base.Function;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.fao.geonet.kernel.KeywordBean;
import org.fao.geonet.kernel.rdf.IdentityResultInterpreter;
import org.fao.geonet.kernel.rdf.KeywordResultInterpreter;
import org.fao.geonet.kernel.rdf.PathDecorator;
import org.fao.geonet.kernel.rdf.Query;
import org.fao.geonet.kernel.rdf.ResultInterpreter;
import org.fao.geonet.kernel.rdf.Selector;
import org.fao.geonet.kernel.rdf.Selectors;
import org.fao.geonet.kernel.rdf.Where;
import org.fao.geonet.kernel.rdf.WhereClause;
import org.fao.geonet.languages.IsoLanguagesMapper;
import org.jdom.Namespace;
import org.openrdf.model.Value;

public class QueryBuilder<Q> {
    private Map<String, Select> selectPaths = new LinkedHashMap<String, Select>();
    private int limit = -1;
    private int offset = -1;
    private boolean distinct = false;
    private ResultInterpreter interpreter = new IdentityResultInterpreter();
    private Where whereClause = null;

    protected QueryBuilder() {
    }

    public static QueryBuilder<Query<LinkedHashMap<String, Value>>> builder() {
        return new QueryBuilder<Query<LinkedHashMap<String, Value>>>();
    }

    public static QueryBuilder<KeywordBean> keywordQueryBuilder(IsoLanguagesMapper mapper, List<String> languages) {
        return QueryBuilder.keywordQueryBuilder(mapper, languages, false);
    }

    public static QueryBuilder<KeywordBean> keywordQueryBuilder(IsoLanguagesMapper mapper, Collection<String> languages, boolean requireBoundedBy) {
        QueryBuilder<KeywordBean> builder = QueryBuilder.builder().distinct(true).selectId().select(Selectors.UPPER_CORNER, requireBoundedBy).select(Selectors.LOWER_CORNER, requireBoundedBy).interpreter(new KeywordResultInterpreter(languages));
        for (String lang : languages) {
            builder.select(Selectors.prefLabel(lang, mapper), false);
            builder.select(Selectors.note(lang, mapper), false);
        }
        return builder;
    }

    public static QueryBuilder<KeywordBean> keywordQueryBuilder(IsoLanguagesMapper mapper, String ... languages) {
        return QueryBuilder.keywordQueryBuilder(mapper, Arrays.asList(languages));
    }

    public static QueryBuilder<String> languagesQueryBuilder(final IsoLanguagesMapper mapper) {
        ResultInterpreter<String> newInterpreter = new IdentityResultInterpreter().onlyColumn("language").map(new Function<Value, String>(){

            public String apply(Value input) {
                if (input == null) {
                    throw new AssertionError((Object)"Input of ResultInterpreter must not be null");
                }
                return mapper.iso639_1_to_iso639_2(input.toString(), "");
            }
        });
        Selector languages = Selectors.languages(Selectors.PREF_LABEL);
        QueryBuilder<String> builder = QueryBuilder.builder().distinct(true).select(languages, true).interpreter(newInterpreter);
        return builder;
    }

    public Query<Q> build() {
        String query = this.createQueryString();
        return new Query(query, this.interpreter);
    }

    protected String createQueryString() {
        String clause;
        StringBuilder variables = new StringBuilder();
        StringBuilder paths = new StringBuilder();
        StringBuilder namespaces = new StringBuilder();
        HashSet<String> addedNamespaces = new HashSet<String>();
        for (Select select : this.selectPaths.values()) {
            this.addTo(variables, select.getVariable());
            this.addTo(paths, select.getPath());
            for (Namespace namespace : select.getNamespaces()) {
                if (addedNamespaces.contains(namespace.getPrefix())) continue;
                addedNamespaces.add(namespace.getPrefix());
                this.addTo(namespaces, namespace.getPrefix() + "=<" + namespace.getURI() + ">");
            }
        }
        StringBuilder statement = new StringBuilder("SELECT ");
        if (this.distinct) {
            statement.append("DISTINCT ");
        }
        statement.append((CharSequence)variables);
        statement.append(" FROM ");
        statement.append((CharSequence)paths);
        statement.append(' ');
        if (this.whereClause != null && !(clause = this.whereClause.getClause()).trim().isEmpty()) {
            statement.append("WHERE ");
            statement.append(this.whereClause.getClause());
            statement.append(' ');
        }
        if (this.limit > -1) {
            statement.append("LIMIT ");
            statement.append(this.limit);
            statement.append(' ');
        }
        if (this.offset > 0) {
            statement.append("OFFSET ");
            statement.append(this.offset);
            statement.append(' ');
        }
        if (namespaces.length() > 0) {
            statement.append("USING NAMESPACE ");
            statement.append((CharSequence)namespaces);
        }
        return statement.toString();
    }

    private void addTo(StringBuilder builder, String value) {
        if (value.trim().length() > 0) {
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append(value);
        }
    }

    public QueryBuilder<Q> select(Selector selector, boolean require) {
        this.selectPaths.put(selector.id, new Select(selector, require));
        return this;
    }

    public QueryBuilder<Q> selectId() {
        return this.select(Selectors.ID, true);
    }

    public QueryBuilder<Q> limit(int limit) {
        this.limit = limit;
        return this;
    }

    public QueryBuilder<Q> distinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public QueryBuilder<Q> offset(int offset) {
        this.offset = offset;
        return this;
    }

    public <N> QueryBuilder<N> interpreter(ResultInterpreter<N> newInterpreter) {
        this.interpreter = newInterpreter;
        return this;
    }

    public QueryBuilder<Q> where(String clause) {
        return this.where(new WhereClause(clause));
    }

    public QueryBuilder<Q> where(Where where) {
        this.whereClause = where;
        return this;
    }

    public String toString() {
        return "QueryBuilder [" + this.createQueryString() + "]";
    }

    private static class Select
    extends PathDecorator {
        public final boolean require;

        public Select(Selector path, boolean require) {
            super(path);
            this.require = require;
        }

        @Override
        public String getPath() {
            if (!super.getPath().trim().isEmpty()) {
                if (this.require) {
                    return super.getPath();
                }
                return MessageFormat.format("[{0}]", super.getPath());
            }
            return "";
        }
    }
}

