/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.geotools.data.Base64;
import org.geotools.data.DataSourceException;
import org.geotools.data.postgis.TWKBReader;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.CoordinateSequences;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ByteArrayInStream;
import org.locationtech.jts.io.InStream;
import org.locationtech.jts.io.WKBWriter;

class TWKBAttributeIO {
    TWKBReader twkbReader;
    ByteArrayInStream inStream = new ByteArrayInStream(new byte[0]);
    GeometryFactory gf;
    boolean base64EncodingEnabled;

    public TWKBAttributeIO() {
        this(new GeometryFactory());
    }

    public TWKBAttributeIO(GeometryFactory gf) {
        this.twkbReader = new LiteTWKBReader(gf);
        this.gf = gf;
    }

    public void setGeometryFactory(GeometryFactory gf) {
        if (gf != this.gf) {
            this.gf = gf;
            this.twkbReader = new LiteTWKBReader(gf);
        }
    }

    public GeometryFactory getGeometryFactory() {
        return this.gf;
    }

    public boolean isBase64EncodingEnabled() {
        return this.base64EncodingEnabled;
    }

    public void setBase64EncodingEnabled(boolean base64EncodingEnabled) {
        this.base64EncodingEnabled = base64EncodingEnabled;
    }

    private Geometry wkb2Geometry(byte[] wkbBytes) throws IOException {
        if (wkbBytes == null) {
            return null;
        }
        try {
            this.inStream.setBytes(wkbBytes);
            return this.twkbReader.read((InStream)this.inStream);
        }
        catch (Exception e) {
            throw new DataSourceException("An exception occurred while parsing TWKB data", e);
        }
    }

    public Object read(ResultSet rs, String columnName) throws IOException {
        try {
            byte[] bytes = rs.getBytes(columnName);
            if (bytes == null) {
                return null;
            }
            if (this.base64EncodingEnabled) {
                bytes = Base64.decode(bytes);
            }
            return this.wkb2Geometry(bytes);
        }
        catch (SQLException e) {
            throw new DataSourceException("SQL exception occurred while reading the geometry.", e);
        }
    }

    public Object read(ResultSet rs, int columnIndex, Class<?> binding) throws IOException {
        try {
            byte[] bytes = rs.getBytes(columnIndex);
            if (bytes == null) {
                return null;
            }
            if (this.base64EncodingEnabled) {
                bytes = Base64.decode(bytes);
            }
            Geometry g = this.wkb2Geometry(bytes);
            g = this.adaptToBinding(g, binding);
            return g;
        }
        catch (SQLException e) {
            throw new DataSourceException("SQL exception occurred while reading the geometry.", e);
        }
    }

    public Object read(ResultSet rs, String columnName, Class<?> binding) throws IOException {
        try {
            byte[] bytes = rs.getBytes(columnName);
            if (bytes == null) {
                return null;
            }
            Geometry g = this.wkb2Geometry(Base64.decode(bytes));
            g = this.adaptToBinding(g, binding);
            return g;
        }
        catch (SQLException e) {
            throw new DataSourceException("SQL exception occurred while reading the geometry.", e);
        }
    }

    public Geometry adaptToBinding(Geometry g, Class<?> binding) {
        if (g instanceof Point && !binding.isInstance(g)) {
            CoordinateSequence cs = ((Point)g).getCoordinateSequence();
            if (Polygon.class.isAssignableFrom(binding)) {
                g = this.toPolygon(cs);
            } else if (LineString.class.isAssignableFrom(binding)) {
                g = this.toLineString(cs);
            } else if (MultiPolygon.class.isAssignableFrom(binding)) {
                Polygon p = this.toPolygon(cs);
                g = this.gf.createMultiPolygon(new Polygon[]{p});
            } else if (MultiLineString.class.isAssignableFrom(binding)) {
                LineString ls = this.toLineString(cs);
                g = this.gf.createMultiLineString(new LineString[]{ls});
            }
        }
        return g;
    }

    public LineString toLineString(CoordinateSequence cs) {
        CoordinateSequence lineSequence = CoordinateSequences.extend((CoordinateSequenceFactory)this.gf.getCoordinateSequenceFactory(), (CoordinateSequence)cs, (int)2);
        return this.gf.createLineString(lineSequence);
    }

    public Polygon toPolygon(CoordinateSequence cs) {
        CoordinateSequence ringSequence = CoordinateSequences.ensureValidRing((CoordinateSequenceFactory)this.gf.getCoordinateSequenceFactory(), (CoordinateSequence)cs);
        LinearRing shell = this.gf.createLinearRing(ringSequence);
        return this.gf.createPolygon(shell);
    }

    public void write(PreparedStatement ps, int position, Object value) throws IOException {
        try {
            if (value == null) {
                ps.setNull(position, 1111);
            } else {
                ps.setBytes(position, new WKBWriter().write((Geometry)value));
            }
        }
        catch (SQLException e) {
            throw new DataSourceException("SQL exception occurred while reading the geometry.", e);
        }
    }

    public static byte getFromChar(char c) {
        if (c <= '9') {
            return (byte)(c - 48);
        }
        if (c <= 'F') {
            return (byte)(c - 65 + 10);
        }
        return (byte)(c - 97 + 10);
    }

    static final class LiteTWKBReader
    extends TWKBReader {
        public LiteTWKBReader(GeometryFactory geometryFactory) {
            super(geometryFactory);
        }

        @Override
        protected CoordinateSequence readCoordinateSequence(int numPts, TWKBReader.TWKBMetadata metadata) throws IOException {
            if (!(this.csFactory instanceof LiteCoordinateSequenceFactory)) {
                return super.readCoordinateSequence(numPts, metadata);
            }
            int dims = metadata.getDims();
            LiteCoordinateSequence seq = (LiteCoordinateSequence)this.csFactory.create(numPts, dims);
            double[] ordinates = new double[numPts * dims];
            double[] scales = new double[dims];
            for (int i = 0; i < scales.length; ++i) {
                scales[i] = metadata.getScale(i);
            }
            int k = 0;
            for (int i = 0; i < numPts; ++i) {
                for (int j = 0; j < dims; ++j) {
                    double value;
                    double ordinateDelta = this.readNextDouble(scales[j]);
                    metadata.valueArray[j] = value = metadata.valueArray[j] + ordinateDelta;
                    ordinates[k++] = value;
                }
            }
            seq.setArray(ordinates);
            return seq;
        }
    }
}

