/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.maintenance;

import java.util.Collection;
import java.util.Date;
import org.geotools.metadata.iso.MetadataEntity;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.maintenance.MaintenanceFrequency;
import org.opengis.metadata.maintenance.MaintenanceInformation;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.maintenance.ScopeDescription;
import org.opengis.temporal.PeriodDuration;
import org.opengis.util.InternationalString;

public class MaintenanceInformationImpl
extends MetadataEntity
implements MaintenanceInformation {
    private static final long serialVersionUID = 8523463344581266776L;
    private MaintenanceFrequency maintenanceAndUpdateFrequency;
    private long dateOfNextUpdate = Long.MIN_VALUE;
    private PeriodDuration userDefinedMaintenanceFrequency;
    private Collection<ScopeCode> updateScopes;
    private Collection<ScopeDescription> updateScopeDescriptions;
    private Collection<InternationalString> maintenanceNotes;
    private Collection<ResponsibleParty> contacts;

    public MaintenanceInformationImpl() {
    }

    public MaintenanceInformationImpl(MaintenanceInformation source) {
        super(source);
    }

    public MaintenanceInformationImpl(MaintenanceFrequency maintenanceAndUpdateFrequency) {
        this.setMaintenanceAndUpdateFrequency(maintenanceAndUpdateFrequency);
    }

    @Override
    public MaintenanceFrequency getMaintenanceAndUpdateFrequency() {
        return this.maintenanceAndUpdateFrequency;
    }

    public void setMaintenanceAndUpdateFrequency(MaintenanceFrequency newValue) {
        this.checkWritePermission();
        this.maintenanceAndUpdateFrequency = newValue;
    }

    @Override
    public Date getDateOfNextUpdate() {
        return this.dateOfNextUpdate != Long.MIN_VALUE ? new Date(this.dateOfNextUpdate) : null;
    }

    public void setDateOfNextUpdate(Date newValue) {
        this.checkWritePermission();
        this.dateOfNextUpdate = newValue != null ? newValue.getTime() : Long.MIN_VALUE;
    }

    @Override
    public PeriodDuration getUserDefinedMaintenanceFrequency() {
        return this.userDefinedMaintenanceFrequency;
    }

    public void setUserDefinedMaintenanceFrequency(PeriodDuration newValue) {
        this.checkWritePermission();
        this.userDefinedMaintenanceFrequency = newValue;
    }

    @Override
    public Collection<ScopeCode> getUpdateScopes() {
        this.updateScopes = this.nonNullCollection(this.updateScopes, ScopeCode.class);
        return this.updateScopes;
    }

    public void setUpdateScopes(Collection<? extends ScopeCode> newValues) {
        this.updateScopes = this.copyCollection(newValues, this.updateScopes, ScopeCode.class);
    }

    public Collection<ScopeDescription> getUpdateScopeDescriptions() {
        this.updateScopeDescriptions = this.nonNullCollection(this.updateScopeDescriptions, ScopeDescription.class);
        return this.updateScopeDescriptions;
    }

    public void setUpdateScopeDescriptions(Collection<? extends ScopeDescription> newValues) {
        this.updateScopeDescriptions = this.copyCollection(newValues, this.updateScopeDescriptions, ScopeDescription.class);
    }

    public Collection<InternationalString> getMaintenanceNotes() {
        this.maintenanceNotes = this.nonNullCollection(this.maintenanceNotes, InternationalString.class);
        return this.maintenanceNotes;
    }

    public void setMaintenanceNotes(Collection<? extends InternationalString> newValues) {
        this.maintenanceNotes = this.copyCollection(newValues, this.maintenanceNotes, InternationalString.class);
    }

    public Collection<ResponsibleParty> getContacts() {
        this.contacts = this.nonNullCollection(this.contacts, ResponsibleParty.class);
        return this.contacts;
    }

    public void setContacts(Collection<? extends ResponsibleParty> newValues) {
        this.contacts = this.copyCollection(newValues, this.contacts, ResponsibleParty.class);
    }
}

