/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.BooleanCollection;
import bak.pcj.hash.DefaultBooleanHashFunction;
import bak.pcj.hash.DefaultDoubleHashFunction;
import bak.pcj.map.DoubleKeyBooleanMap;
import bak.pcj.map.DoubleKeyBooleanMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.DoubleSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractDoubleKeyBooleanMap
implements DoubleKeyBooleanMap {
    protected AbstractDoubleKeyBooleanMap() {
    }

    public void clear() {
        DoubleKeyBooleanMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public boolean remove(double key) {
        DoubleKeyBooleanMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            boolean value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultBoolean();
    }

    public void putAll(DoubleKeyBooleanMap map) {
        DoubleKeyBooleanMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(double key) {
        DoubleKeyBooleanMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public boolean get(double key) {
        DoubleKeyBooleanMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultBoolean();
    }

    public boolean containsValue(boolean value) {
        DoubleKeyBooleanMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DoubleKeyBooleanMap)) {
            return false;
        }
        DoubleKeyBooleanMap map = (DoubleKeyBooleanMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        DoubleKeyBooleanMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            double k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        DoubleKeyBooleanMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultDoubleHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultBooleanHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        DoubleKeyBooleanMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public boolean tget(double key) {
        boolean value = this.get(key);
        if (value == MapDefaults.defaultBoolean() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        DoubleKeyBooleanMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract BooleanCollection values();

    public abstract boolean put(double var1, boolean var3);

    public abstract boolean lget();

    public abstract DoubleSet keySet();

    public abstract DoubleKeyBooleanMapIterator entries();
}

