/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.list;

import bak.pcj.AbstractDoubleCollection;
import bak.pcj.DoubleCollection;
import bak.pcj.DoubleIterator;
import bak.pcj.hash.DefaultDoubleHashFunction;
import bak.pcj.list.DoubleList;
import bak.pcj.list.DoubleListIterator;
import bak.pcj.util.Exceptions;

public abstract class AbstractDoubleList
extends AbstractDoubleCollection
implements DoubleList {
    protected AbstractDoubleList() {
    }

    public boolean add(double v) {
        this.add(this.size(), v);
        return true;
    }

    public void add(int index, double v) {
        Exceptions.unsupported("add");
    }

    public boolean addAll(int index, DoubleCollection c) {
        if (index < 0 || index > this.size()) {
            Exceptions.indexOutOfBounds(index, 0, this.size());
        }
        DoubleIterator i = c.iterator();
        boolean result = i.hasNext();
        while (i.hasNext()) {
            this.add(index, i.next());
            ++index;
        }
        return result;
    }

    public int indexOf(double c) {
        return this.indexOf(0, c);
    }

    public int indexOf(int index, double c) {
        DoubleListIterator i = this.listIterator(index);
        while (i.hasNext()) {
            if (i.next() != c) continue;
            return i.previousIndex();
        }
        return -1;
    }

    public DoubleIterator iterator() {
        return this.listIterator();
    }

    public int lastIndexOf(double c) {
        DoubleListIterator i = this.listIterator(this.size());
        while (i.hasPrevious()) {
            if (i.previous() != c) continue;
            return i.nextIndex();
        }
        return -1;
    }

    public int lastIndexOf(int index, double c) {
        DoubleListIterator i = this.listIterator(index);
        while (i.hasPrevious()) {
            if (i.previous() != c) continue;
            return i.nextIndex();
        }
        return -1;
    }

    public DoubleListIterator listIterator() {
        return this.listIterator(0);
    }

    public DoubleListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            Exceptions.indexOutOfBounds(index, 0, this.size());
        }
        return new DoubleListIterator(index){
            private int ptr;
            private int lptr;
            private final /* synthetic */ int val$index;
            {
                this.ptr = this.val$index = val$index;
                this.lptr = -1;
            }

            public boolean hasNext() {
                return this.ptr < AbstractDoubleList.this.size();
            }

            public double next() {
                if (this.ptr == AbstractDoubleList.this.size()) {
                    Exceptions.endOfIterator();
                }
                this.lptr = this.ptr++;
                return AbstractDoubleList.this.get(this.lptr);
            }

            public void remove() {
                if (this.lptr == -1) {
                    Exceptions.noElementToRemove();
                }
                AbstractDoubleList.this.removeElementAt(this.lptr);
                if (this.lptr < this.ptr) {
                    --this.ptr;
                }
                this.lptr = -1;
            }

            public void add(double v) {
                AbstractDoubleList.this.add(this.ptr++, v);
                this.lptr = -1;
            }

            public boolean hasPrevious() {
                return this.ptr > 0;
            }

            public int nextIndex() {
                return this.ptr;
            }

            public double previous() {
                if (this.ptr == 0) {
                    Exceptions.startOfIterator();
                }
                --this.ptr;
                this.lptr = this.ptr;
                return AbstractDoubleList.this.get(this.ptr);
            }

            public int previousIndex() {
                return this.ptr - 1;
            }

            public void set(double v) {
                if (this.lptr == -1) {
                    Exceptions.noElementToSet();
                }
                AbstractDoubleList.this.set(this.lptr, v);
            }
        };
    }

    public double removeElementAt(int index) {
        Exceptions.unsupported("removeElementAt");
        throw new RuntimeException();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DoubleList)) {
            return false;
        }
        DoubleListIterator i1 = this.listIterator();
        DoubleListIterator i2 = ((DoubleList)obj).listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (i1.next() == i2.next()) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    public int hashCode() {
        int h = 1;
        DoubleIterator i = this.iterator();
        while (i.hasNext()) {
            h = 31 * h + DefaultDoubleHashFunction.INSTANCE.hash(i.next());
        }
        return h;
    }

    public abstract double set(int var1, double var2);

    public abstract double get(int var1);
}

