/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.adapter.CharCollectionToCollectionAdapter;
import bak.pcj.hash.DefaultCharHashFunction;
import bak.pcj.map.MapDefaults;
import bak.pcj.map.ObjectKeyCharMap;
import bak.pcj.map.ObjectKeyCharMapIterator;
import bak.pcj.util.Exceptions;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ObjectKeyCharMapToMapAdapter
implements Map {
    protected ObjectKeyCharMap map;

    public ObjectKeyCharMapToMapAdapter(ObjectKeyCharMap map) throws NullPointerException {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        return this.map.containsValue(((Character)value).charValue());
    }

    public Set entrySet() {
        return new EntrySet();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Map)) {
            return false;
        }
        Map m = (Map)obj;
        if (m.size() != this.map.size()) {
            return false;
        }
        Iterator i = m.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            if (e.getValue() == null) {
                return false;
            }
            if (this.get(e.getKey()).equals(e.getValue())) continue;
            return false;
        }
        return true;
    }

    public Object get(Object key) {
        char v = this.map.get(key);
        if (v == MapDefaults.defaultChar() && !this.map.containsKey(key)) {
            return null;
        }
        return new Character(v);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Object put(Object key, Object value) throws NullPointerException, ClassCastException {
        Object result = this.get(key);
        this.map.put(key, ((Character)value).charValue());
        return result;
    }

    public void putAll(Map map) throws NullPointerException, ClassCastException {
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    public Object remove(Object key) {
        Object result = this.get(key);
        this.map.remove(key);
        return result;
    }

    public int size() {
        return this.map.size();
    }

    public Collection values() {
        return new CharCollectionToCollectionAdapter(this.map.values());
    }

    class Entry
    implements Map.Entry {
        Object key;
        Character value;

        Entry(Object key, char value) {
            this.key = key;
            this.value = new Character(value);
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            return ObjectKeyCharMapToMapAdapter.this.put(this.key, value);
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ DefaultCharHashFunction.INSTANCE.hash(this.value.charValue());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)obj;
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && this.value.equals(e.getValue());
        }
    }

    class EntrySet
    extends AbstractSet {
        EntrySet() {
        }

        public Iterator iterator() {
            return new Iterator(this){
                ObjectKeyCharMapIterator i;
                private final /* synthetic */ EntrySet this$1;
                {
                    this.this$1 = this$1;
                    this.i = EntrySet.access$000((EntrySet)this.this$1).map.entries();
                }

                public boolean hasNext() {
                    return this.i.hasNext();
                }

                public Object next() {
                    this.i.next();
                    return EntrySet.access$000(this.this$1).new Entry(this.i.getKey(), this.i.getValue());
                }

                public void remove() {
                    this.i.remove();
                }
            };
        }

        public boolean add(Object obj) {
            Map.Entry e = (Map.Entry)obj;
            if (this.contains(e)) {
                return false;
            }
            ObjectKeyCharMapToMapAdapter.this.put(e.getKey(), e.getValue());
            return true;
        }

        public int size() {
            return ObjectKeyCharMapToMapAdapter.this.map.size();
        }

        static /* synthetic */ ObjectKeyCharMapToMapAdapter access$000(EntrySet x0) {
            return x0.ObjectKeyCharMapToMapAdapter.this;
        }
    }
}

