/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.IntCollection;
import bak.pcj.adapter.CollectionToIntCollectionAdapter;
import bak.pcj.map.AbstractObjectKeyIntMap;
import bak.pcj.map.MapDefaults;
import bak.pcj.map.ObjectKeyIntMap;
import bak.pcj.map.ObjectKeyIntMapIterator;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MapToObjectKeyIntMapAdapter
extends AbstractObjectKeyIntMap
implements ObjectKeyIntMap {
    protected Map map;
    protected Integer lastValue;

    public MapToObjectKeyIntMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToObjectKeyIntMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(Object key) {
        this.lastValue = (Integer)this.map.get(key);
        return this.lastValue != null;
    }

    public boolean containsValue(int value) {
        return this.map.containsValue(new Integer(value));
    }

    public ObjectKeyIntMapIterator entries() {
        return new ObjectKeyIntMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToObjectKeyIntMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public Object getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return this.lastEntry.getKey();
            }

            public int getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Integer)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public int get(Object key) {
        Integer value = (Integer)this.map.get(key);
        return value == null ? MapDefaults.defaultInt() : value;
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public int lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public int put(Object key, int value) {
        Integer oldValue = this.map.put(key, new Integer(value));
        return oldValue == null ? MapDefaults.defaultInt() : oldValue;
    }

    public int remove(Object key) {
        Integer value = (Integer)this.map.remove(key);
        return value == null ? MapDefaults.defaultInt() : value;
    }

    public int size() {
        return this.map.size();
    }

    public IntCollection values() {
        return new CollectionToIntCollectionAdapter(this.map.values());
    }

    public int tget(Object key) {
        Integer value = (Integer)this.map.get(key);
        if (value == null) {
            Exceptions.noSuchMapping(key);
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isObjectKeyIntAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

