/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.BooleanCollection;
import bak.pcj.adapter.CollectionToBooleanCollectionAdapter;
import bak.pcj.adapter.SetToDoubleSetAdapter;
import bak.pcj.map.AbstractDoubleKeyBooleanMap;
import bak.pcj.map.DoubleKeyBooleanMap;
import bak.pcj.map.DoubleKeyBooleanMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.DoubleSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToDoubleKeyBooleanMapAdapter
extends AbstractDoubleKeyBooleanMap
implements DoubleKeyBooleanMap {
    protected Map map;
    protected Boolean lastValue;

    public MapToDoubleKeyBooleanMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToDoubleKeyBooleanMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(double key) {
        this.lastValue = (Boolean)this.map.get(new Double(key));
        return this.lastValue != null;
    }

    public boolean containsValue(boolean value) {
        return this.map.containsValue(new Boolean(value));
    }

    public DoubleKeyBooleanMapIterator entries() {
        return new DoubleKeyBooleanMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToDoubleKeyBooleanMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public double getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Double)this.lastEntry.getKey();
            }

            public boolean getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Boolean)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public boolean get(double key) {
        Boolean value = (Boolean)this.map.get(new Double(key));
        return value == null ? MapDefaults.defaultBoolean() : value;
    }

    public DoubleSet keySet() {
        return new SetToDoubleSetAdapter(this.map.keySet());
    }

    public boolean lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public boolean put(double key, boolean value) {
        Boolean oldValue = this.map.put(new Double(key), new Boolean(value));
        return oldValue == null ? MapDefaults.defaultBoolean() : oldValue;
    }

    public boolean remove(double key) {
        Boolean value = (Boolean)this.map.remove(new Double(key));
        return value == null ? MapDefaults.defaultBoolean() : value;
    }

    public int size() {
        return this.map.size();
    }

    public BooleanCollection values() {
        return new CollectionToBooleanCollectionAdapter(this.map.values());
    }

    public boolean tget(double key) {
        Boolean value = (Boolean)this.map.get(new Double(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isDoubleKeyBooleanAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

