/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj;

import bak.pcj.CharCollection;
import bak.pcj.CharIterator;
import bak.pcj.util.Exceptions;

public class SynchronizedCharCollection
implements CharCollection {
    protected CharCollection collection;
    protected Object m;

    public SynchronizedCharCollection(CharCollection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        this.collection = c;
        this.m = this;
    }

    public boolean add(char v) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.add(v);
            return bl;
        }
    }

    public boolean addAll(CharCollection c) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.addAll(c);
            return bl;
        }
    }

    public void clear() {
        Object object = this.m;
        synchronized (object) {
            this.collection.clear();
        }
    }

    public boolean contains(char v) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.contains(v);
            return bl;
        }
    }

    public boolean containsAll(CharCollection c) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.containsAll(c);
            return bl;
        }
    }

    public boolean equals(Object obj) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.equals(obj);
            return bl;
        }
    }

    public int hashCode() {
        Object object = this.m;
        synchronized (object) {
            int n = this.collection.hashCode();
            return n;
        }
    }

    public boolean isEmpty() {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.isEmpty();
            return bl;
        }
    }

    public CharIterator iterator() {
        Object object = this.m;
        synchronized (object) {
            CharIterator charIterator = this.collection.iterator();
            return charIterator;
        }
    }

    public boolean remove(char v) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.remove(v);
            return bl;
        }
    }

    public boolean removeAll(CharCollection c) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.removeAll(c);
            return bl;
        }
    }

    public boolean retainAll(CharCollection c) {
        Object object = this.m;
        synchronized (object) {
            boolean bl = this.collection.retainAll(c);
            return bl;
        }
    }

    public int size() {
        Object object = this.m;
        synchronized (object) {
            int n = this.collection.size();
            return n;
        }
    }

    public char[] toArray() {
        Object object = this.m;
        synchronized (object) {
            char[] cArray = this.collection.toArray();
            return cArray;
        }
    }

    public char[] toArray(char[] a) {
        Object object = this.m;
        synchronized (object) {
            char[] cArray = this.collection.toArray(a);
            return cArray;
        }
    }

    public void trimToSize() {
        Object object = this.m;
        synchronized (object) {
            this.collection.trimToSize();
        }
    }
}

